/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#define SM_SCCNFDEF 1

#include "sm/generic.h"
SM_RCSID("@(#)$Id: scconf.c,v 1.18 2005/09/27 16:59:16 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/sysexits.h"
#include "sm/string.h"
#include "sm/io.h"
#include "sm/qmgrcomm.h"
#include "sm/sm-conf.h"
#include "sm/sm-conf-prt.h"
#define SM_LOG_IDENT	"smtpc"
#define SM_CONF_LOG_DEF 1
#define SM_CONF_TIME_DEF 1
#include "smtpc.h"
#include "sm/sccnf.h"
#include "sm/sccnfdef.h"

/*
**  SC_READ_CNF -- Read configuration file
**
**	Parameters:
**		sc_ctx -- SMTPC context
**		fn -- filename of configuration file
**		psmc -- (pointer to) configuration context (output)
**
**	Returns:
**		0 on success, everything else is an error
*/

sm_ret_T
sc_read_cnf(sc_ctx_P sc_ctx, const char *fn, sm_conf_T **psmc)
{
	int err, i;
	sm_conf_T *smc;
	FILE *fp;
	sm_conf_iterator_T sc_cnf_iter;
	char const *sc_cnf_name;
	size_t sc_cnf_name_n;
	char thissmtpc[MAXSECTIONNAME];

	fp = NULL;
	smc = sm_conf_new(fn);
	if (smc == NULL)
	{
		err = errno;

		sm_io_fprintf(smioerr, "%s: sm_conf_new=NULL, errno=%d\n",
			fn, err);
		return ENOMEM;
	}
	err = sm_conf_read_FILE(smc, fn, fp);
	if (err != 0)
	{
		sm_prt_conferr(fn, smc, err);
		goto error;
	}

	err = sm_conf_scan(smc, sc_global_defs, SM_CONF_FLAG_ALLOW_ANY,
			&sc_ctx->scc_cnf);
	if (err != 0)
	{
		sm_prt_conferr(fn, smc, err);
		goto error;
	}

	sc_cnf_iter = NULL;
	if (sc_ctx->scc_cnf.sc_cnf_section != NULL)
		sm_snprintf(thissmtpc, sizeof(thissmtpc), "smtpc{%s}",
			sc_ctx->scc_cnf.sc_cnf_section);
	else
		strlcpy(thissmtpc, "smtpc", sizeof(thissmtpc));
	err = sm_conf_scan_next(smc, thissmtpc, sc_defs, 0,
				&sc_cnf_name, &sc_cnf_name_n,
				&(sc_ctx->scc_cnf), &sc_cnf_iter);
	if (err != 0 &&
	    (sc_ctx->scc_cnf.sc_cnf_section != NULL
	     || err != SM_CONF_ERR_NOT_FOUND))
		sm_prt_conferr(fn, smc, err);
	else
		err = 0;


	/*
	**  Use configuration data to set other variables
	**  and perform some actions.
	*/

	if (sc_ctx->scc_cnf.sc_cnf_hostname != NULL)
	{
		size_t l;

		l = strlen(sc_ctx->scc_cnf.sc_cnf_hostname) + 1;
		sc_ctx->scc_hostname = sm_str_scpyn0(NULL,
			sc_ctx->scc_cnf.sc_cnf_hostname, l, l);
		if (sc_ctx->scc_hostname == NULL)
		{
			err = sm_error_temp(SM_EM_Q_CONF, ENOMEM);
			goto error;
		}
	}

#if 0
	err = sm_conf_scan_next(smc, "sc.log",
			sc_defs, 0, &conf_name, &conf_name_n,
			&s, &conf_iter);
#endif /* 0 */
	i = sc_ctx->scc_cnf.sc_cnf_log.sm_logspc_facility;

	/*
	**  HACK! it should check whether log is in config file
	**  however it's not clear how to do that...
	**  this only works because facility 0 is KERN.
	*/

	if (i != 0)
	{
		err = sm_log_opensyslog(
			sc_ctx->scc_cnf.sc_cnf_log.sm_logspc_ident,
			sc_ctx->scc_cnf.sc_cnf_log.sm_logspc_opt, i);
		if (sm_is_err(err))
			goto error;
		err = sm_log_setfp_fd(sc_ctx->scc_lctx, NULL, INVALID_FD);
		if (sm_is_err(err))
			goto error;
	}

	if (psmc != NULL)
		*psmc = smc;

	return SM_SUCCESS;

  error:
	if (smc != NULL)
	{
		sm_conf_destroy(smc);
		smc = NULL;
	}
	return err;
}

#if STANDALONE
static int
process(char const *name, FILE *fp)
{
	sm_conf_T		*stream;
	int			err;
	sc_cnf_T		s;
	sm_conf_iterator_T	sc_cnf_iter;
	char const		*sc_cnf_name;
	size_t			sc_cnf_name_n;

	if (((stream = sm_conf_new(name ? name : "*stdin*"))) == NULL)
	{
		fprintf(stderr, "error -- sm_conf_new() returns NULL!\n");
		return 1;
	}
	if ((err = sm_conf_read_FILE(stream, name, fp)) != 0)
	{
		char buf[200];
		char const *e = NULL;

		fprintf(stderr, "%s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(stream, e)) != NULL)
			fprintf(stderr, "%s\n", e);

		sm_conf_destroy(stream);
		return 2;
	}

	sc_cnf_iter = NULL;
	while ((err = sm_conf_scan_next(stream, "sc",
				mcp_defs, 0, &sc_cnf_name, &sc_cnf_name_n,
				&s, &sc_cnf_iter)) == 0)
	{
		print_structure(&s, sc_cnf_name, sc_cnf_name_n);
	}
	if (err != 0 && err != SM_CONF_ERR_NOT_FOUND)
	{
		char buf[200];
		char const *e = NULL;

		fprintf(stderr, "(while scanning) %s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(stream, e)) != NULL)
			fprintf(stderr, "%s\n", e);

		sm_conf_destroy(stream);
		return 3;
	}
	sm_conf_destroy(stream);
	return 0;
}

int
main(int ac, char **av)
{
	int	ret;
	int	ai;

	ret = 0;	/* make compiler happy */
	if (ac == 1)
		ret = process("*stdin*", stdin);
	else
	{
		for (ai = 1; ai < ac; ai++)
		{
			ret = process(av[ai], NULL);
			if (ret != 0)
				break;
		}
	}

	return ret;
}
#endif /* STANDALONE */
