#!/bin/sh
# $Id: t-mt-0.sh,v 1.14 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# simple mailertable routing tests by contacting SMAR
# uses t-smar-1 and startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=mt-0.out
IP=mt-0.ip
OK=mt-0.ok
TPRG=./t-smar-1
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${SOCK} ${PIDS}

# prepare mailertable
# note: bogus.org has trailing space
${CAT} > ${MT} <<EOF
host123.sm9.org	[1.2.3.0]
sm9.org	[1.2.3.2]
.sm9.org	[1.2.3.4]
.org		[1.2.3.6]
.		[1.2.3.9]
bogus.org	[1.0.0.64] 
blank2.org	[1.0.0.65]    [1.0.0.66]     
local.dom	lmtp:
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1

rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@host123.sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=1.2.3.0 [1020300]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@host124.sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=1.2.3.4 [1020304]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@sm9.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=1.2.3.2 [1020302]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@smx.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=1.2.3.6 [1020306]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=5
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@smx.com>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=1.2.3.9 [1020309]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=6
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@bogus.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=1.0.0.64 [1000040]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=7
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<a@blank2.org>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=1.0.0.65 [1000041]
IP[1]=1.0.0.66 [1000042]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=8
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<local@local.dom>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

rm -f ${OUT} ${IP} ${OK}


# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

exit ${ERRS}
