/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-sockmap-0.c,v 1.7 2005/01/27 00:29:19 ca Exp $")

#include "sm/error.h"
#include "sm/heap.h"
#include "sm/memops.h"
#include "sm/test.h"
#include "sm/maps.h"
#include "sm/mapc.h"
#include "sm/map.h"
#include "sm/mapclasses.h"
#include "sm/net.h"

#include "sm/io.h"

int Verbose = 0;

#define MAPC_TYPE	"sockmap"
#define MAPC_NAME	"name"

static void
testh(char *name, char *path, ipv4_T ipv4, short port)
{
	sm_ret_T ret;
	sm_maps_P maps;
	sm_map_P map;
	sm_cstr_P mtype, mname;
	sm_str_P lhs, rhs;

	maps = NULL;
	mtype = mname = NULL;
	lhs = rhs = NULL;

	ret = sm_maps_init(&maps);
	SM_TEST(maps != NULL);
	if (maps == NULL)
		return;
	SM_TEST(sm_is_success(ret));

	mtype = sm_cstr_scpyn0((const uchar *)MAPC_TYPE, strlen(MAPC_TYPE));
	SM_TEST(mtype != NULL);
	if (mtype == NULL)
		goto error;

	mname = sm_cstr_scpyn0((const uchar *)MAPC_NAME, strlen(MAPC_NAME));
	SM_TEST(mname != NULL);
	if (mname == NULL)
		goto error;

	lhs = sm_str_new(NULL, 256, 1024);
	SM_TEST(lhs != NULL);
	if (lhs == NULL)
		goto error;

	rhs = sm_str_new(NULL, 256, 1024);
	SM_TEST(rhs != NULL);
	if (rhs == NULL)
		goto error;

	ret = sm_sockmap_class_create(maps);
	SM_TEST(sm_is_success(ret));

	map = NULL;
	ret = sm_map_open(maps, mname, mtype, 0, name, SMAP_MODE_RDWR, &map,
		SMPO_SOCKPATH, path, SMPO_PORT, port, SMPO_IPV4, ipv4,
		SMPO_END);
	SM_TEST(sm_is_success(ret));
	if (!sm_is_success(ret))
		goto error;

	sm_str_clr(rhs);
	sm_str_clr(lhs);
	sm_str_scat(lhs, (const char *)"bastiaan.bakker@example.com");
	ret = sm_map_lookup(map, SMMAP_FL_NONE, lhs, rhs);
	SM_TEST(sm_is_success(ret));

	sm_str_clr(rhs);
	sm_str_clr(lhs);
	sm_str_scat(lhs, (const char *)"wolter.eldering@example.com");
	ret = sm_map_lookup(map, SMMAP_FL_NONE, lhs, rhs);
	SM_TEST(sm_is_success(ret));

	sm_str_clr(rhs);
	sm_str_clr(lhs);
	sm_str_scat(lhs, (const char *)"no@example.com");
	ret = sm_map_lookup(map, SMMAP_FL_NONE, lhs, rhs);
	SM_TEST(sm_is_err(ret));

	sm_str_clr(rhs);
	sm_str_clr(lhs);
	sm_str_scat(lhs, (const char *)"TIMEOUT");
	ret = sm_map_lookup(map, SMMAP_FL_NONE, lhs, rhs);
	SM_TEST(sm_is_err(ret));

	sm_str_clr(rhs);
	sm_str_clr(lhs);
	sm_str_scat(lhs, (const char *)"wolter.eldering@example.com");
	ret = sm_map_lookup(map, SMMAP_FL_NONE, lhs, rhs);
	SM_TEST(sm_is_success(ret));

	sm_str_clr(rhs);
	sm_str_clr(lhs);
	sm_str_scat(lhs, (const char *)"bastiaan.bakker@example.com");
	ret = sm_map_lookup(map, SMMAP_FL_NONE, lhs, rhs);
	SM_TEST(sm_is_success(ret));

	ret = sm_map_close(map, 0);
	SM_TEST(sm_is_success(ret));

	ret = sm_maps_term(maps);
	SM_TEST(sm_is_success(ret));
	SM_CSTR_FREE(mtype);
	SM_CSTR_FREE(mname);
	SM_STR_FREE(lhs);
	SM_STR_FREE(rhs);
	return;

  error:
	sm_maps_term(maps);
}


int
main(int argc, char *argv[])
{
	char *path, *name;
	ipv4_T ipv4;
	short port;
	int c;

	path = NULL;
	name = "virtuser";
	port = 1289;
	ipv4 = ntohl(0x7F000001);
	while ((c = getopt(argc, argv, "N:P:p:a:H:s:V")) != -1)
	{
		switch (c)
		{
		  case 'N':
			name = strdup(optarg);
			if (name == NULL)
				return 1;
			break;
		  case 'P':
			path = strdup(optarg);
			if (path == NULL)
				return 1;
			break;
		  case 'p':
			port = atoi(optarg);
			break;
		  case 'a':
			ipv4 = (ipv4_T) atol(optarg);
			break;
		  default:
			return 1;
		}
	}
	sm_test_begin(argc, argv, "test socket map 0");
	testh(name, path, ipv4, port);
	return sm_test_end();
}
