/*
 * Copyright (c) 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sm_inet_ipv42arpa.c,v 1.2 2005/01/18 00:06:21 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/ctype.h"
#include "sm/net.h"
#include "sm/str.h"

/*
**  SM_INET_IPV4STR -- convert an IPv4 address to IN-ADDR.ARPA format
**
**	Parameters:
**		ipv4 -- IPv4 address
**		dst -- append IN-ADDR ARPA ASCII representation (output)
**
**	Returns:
**		usual sm_error
*/

sm_ret_T
sm_inet_ipv42arpastr(ipv4_T ipv4, sm_str_P dst)
{
	uchar *src;
	ssize_t l;

	src = (uchar *) &ipv4;
	l = sm_str_printf(dst, "%u.%u.%u.%u.in-addr.arpa",
		src[3], src[2], src[1], src[0]);
	if (l <= 0)
		return sm_error_perm(SM_EM_IP, ENOSPC);
	return SM_SUCCESS;
}

/*
**  SM_INET_INADDR2STR -- convert an IPv4 address struct to IN-ADDR.ARPA format
**
**	Parameters:
**		inaddr -- IPv4 address struct
**		dst -- append IN-ADDR ARPA ASCII representation (output)
**
**	Returns:
**		usual sm_error
*/

sm_ret_T
sm_inet_inaddr2arpastr(struct in_addr inaddr, sm_str_P dst)
{
	uchar *src;
	ssize_t l;

	src = (uchar *) &inaddr;
	l = sm_str_printf(dst, "%u.%u.%u.%u.in-addr.arpa",
		src[3], src[2], src[1], src[0]);
	if (l <= 0)
		return sm_error_perm(SM_EM_IP, ENOSPC);
	return SM_SUCCESS;
}
