/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbgetuint64.c,v 1.4 2005/03/29 19:53:12 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/rcb.h"
#include "sm/reccom.h"

/*
**  SM_RCB_GETUINT64 -- Read one uint64 from a sm_rcb_P.
**
**	Parameters:
**		rcb -- sm_rcb_P object to read int from.
**		pu -- pointer to value to return.
**
**	Returns:
**		usual sm_error code; SM_E_OVFLW_NS
**
**	Last code review: 2005-03-29 05:33:17
**	Last code change:
*/

sm_ret_T
sm_rcb_getuint64(sm_rcb_P rcb, uint64_t *pu)
{
	SM_IS_RCB(rcb);
#if SM_RCB_CHECK
	SM_REQUIRE(rcb->sm_rcb_state == SM_RCB_DEC);
#endif
#if PARANOID
	SM_REQUIRE(pu != NULL);
#endif
	if (rcb->sm_rcb_len < rcb->sm_rcb_rw + sizeof(uint64_t))
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	sm_buf2uint64(rcb->sm_rcb_base + rcb->sm_rcb_rw, pu);
	rcb->sm_rcb_rw += sizeof(uint64_t);
	return SM_SUCCESS;
}
