#!/bin/sh
# $Id: t-conf-choice-0.sh,v 1.3 2005/07/18 17:01:42 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`

ERRS=0

CNF=smc0.conf
OUT=smc0.out
OK=smc0.ok

PRG=./t-conf-0

cat > ${CNF} <<EOF
flags = {~flag2,  flag1};
EOF
cat > ${OK} <<EOF
flags= 1
EOF
if ${PRG} -F 2 ${CNF} 2>&1 | grep '^flags' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
flags = {!flag2,  flag1};
EOF
cat > ${OK} <<EOF
flags= 1
EOF
if ${PRG} -F 2 ${CNF} 2>&1 | grep '^flags' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
flags = {-flag2,  flag1};
EOF
cat > ${OK} <<EOF
flags= 1
EOF
if ${PRG} -F 2 ${CNF} 2>&1 | grep '^flags' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
flags = {not_flag2,  flag1};
EOF
cat > ${OK} <<EOF
flags= 1
EOF
if ${PRG} -F 2 ${CNF} 2>&1 | grep '^flags' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
flags = ~flag2;
EOF
cat > ${OK} <<EOF
flags= 0
EOF
if ${PRG} -F 2 ${CNF} 2>&1 | grep '^flags' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
flags = ~flag1;
EOF
cat > ${OK} <<EOF
flags= 0
EOF
if ${PRG} -F 2 ${CNF} 2>&1 | grep '^flags' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
flags = flag1;
EOF
cat > ${OK} <<EOF
flags= 1
EOF
if ${PRG} -F 2 ${CNF} 2>&1 | grep '^flags' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
flags = flag1;
EOF
cat > ${OK} <<EOF
flags= 1
EOF
if ${PRG} ${CNF} 2>&1 | grep '^flags' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
flags = flag2;
EOF
cat > ${OK} <<EOF
flags= 2
EOF
if ${PRG} ${CNF} 2>&1 | grep '^flags' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
