/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm-conf-node.h,v 1.6 2005/09/26 23:26:41 ca Exp $
 */

#ifndef SM_CONF_NODE_H
#define SM_CONF_NODE_H 1

#if SM_LIBCONF_ALONE
#include "sm-conf.h"
#else /* SM_LIBCONF_ALONE */
#include "sm/sm-conf.h"
#endif /* SM_LIBCONF_ALONE */

#include "sm-conf-token.h"

/*
**  SM-CONF-NODE.H -- internal node-related declarations.
**			Used by the parser.
*/

sm_conf_node_T * sm_conf_value_new(
			sm_conf_T	*_smc,
			char const	*_text,
			size_t		_text_n,
			sm_conf_token_T *_token);

sm_conf_node_T	*sm_conf_list_new(
			sm_conf_T	*_smc,
			sm_conf_token_T *_token);

void		sm_conf_list_append(
			sm_conf_T	*_smc,
			sm_conf_node_T	*_list,
			sm_conf_node_T	*_tail);

int		sm_conf_node_argv(
			sm_conf_T		*_smc,
			sm_conf_node_T		*_list_or_value,
			char const * const	**_argv_out);

sm_conf_node_T	*sm_conf_section_new(
			sm_conf_T	*_smc,
			char const	*_section_keyword,
			size_t		_section_keyword_n,
			char const	*_section_name,
			size_t		_section_name_n,
			sm_conf_token_T *_token);

void		sm_conf_section_append(
			sm_conf_T	*_smc,
			sm_conf_node_T	*_section,
			char const	*_name,
			size_t		_name_n,
			sm_conf_node_T	*_sub);

void		sm_conf_node_destroy(
			sm_conf_T	*_smc,
			sm_conf_node_T	*_node);

void		sm_conf_node_terminate(
			sm_conf_T	*_smc,
			sm_conf_node_T	*_node);

void		*sm_conf_node_cache_get(
			sm_conf_node_T		*_node,
			size_t			_size,
			sm_conf_definition_T const *_def,
			void			(*_free_cache)(
					sm_conf_node_T		*_node,
					void			*_data,
					sm_conf_definition_T const *_def),
			int			*result);

#endif	/* SM_CONF_NODE_H */
