/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm-conf-byte.h,v 1.5 2005/06/20 19:03:16 ca Exp $
 */

#ifndef SM_CONF_BYTE_H
#define SM_CONF_BYTE_H 1

#include "sm/generic.h"
#include "sm/assert.h"
#include "sm/magic.h"

#if SM_CONF_BYTE_DEF
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN
sm_conf_definition_T const sm_conf_byte_suffixes[]
#if SM_CONF_BYTE_DEF
=
{
{ SM_CONF_DEF_MAGIC, "B",  sm_conf_type_u32_suffix, 1,
	1024, NULL, 0, NULL, NULL, NULL, "" },
{ SM_CONF_DEF_MAGIC, "KB", sm_conf_type_u32_suffix, 1024,
	1024, NULL, 0, NULL, NULL, NULL, "" },
{ SM_CONF_DEF_MAGIC, "MB", sm_conf_type_u32_suffix, 1024 * 1024,
	1024, NULL, 0, NULL, NULL, NULL, "" },
{ SM_CONF_DEF_MAGIC, "GB", sm_conf_type_u32_suffix, 1024 * 1024 * 1024,
	0, NULL, 0, NULL, NULL, NULL, "" },

/*
**  Hack to be able to read initialization data that uses
**  the macros defined in sm/units.h
*/

{ SM_CONF_DEF_MAGIC, "*1024", sm_conf_type_u32_suffix, 1024,
	0, NULL, 0, NULL, NULL, NULL, "" },
{ SM_CONF_DEF_MAGIC, "*1024*1024", sm_conf_type_u32_suffix, 1024 * 1024,
	0, NULL, 0, NULL, NULL, NULL, "" },
{ SM_CONF_DEF_MAGIC, "*1024*1024*1024", sm_conf_type_u32_suffix, 1024 * 1024 * 1024,
	0, NULL, 0, NULL, NULL, NULL, "" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL },
}
#endif /* SM_CONF_BYTE_DEF */
;

EXTERN
sm_conf_definition_T const sm_conf_Kbyte_suffixes[]
#if SM_CONF_KBYTE_DEF
=
{
{ SM_CONF_DEF_MAGIC, "KB", sm_conf_type_u32_suffix, 1,
	1024, NULL, 0, NULL, NULL, NULL, "" },
{ SM_CONF_DEF_MAGIC, "MB", sm_conf_type_u32_suffix, 1024,
	1024, NULL, 0, NULL, NULL, NULL, "" },
{ SM_CONF_DEF_MAGIC, "GB", sm_conf_type_u32_suffix, 1024 * 1024,
	0, NULL, 0, NULL, NULL, NULL, "" },

/*
**  Hack to be able to read initialization data that uses
**  the macros defined in sm/units.h
*/

{ SM_CONF_DEF_MAGIC, "*1024", sm_conf_type_u32_suffix, 1024,
	0, NULL, 0, NULL, NULL, NULL, "" },
{ SM_CONF_DEF_MAGIC, "*1024*1024", sm_conf_type_u32_suffix, 1024 * 1024,
	0, NULL, 0, NULL, NULL, NULL, "" },

/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL },
}
#endif /* SM_CONF_KBYTE_DEF */
;


#undef EXTERN

#endif /* SM_CONF_BYTE_H */
