/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: rcbcomm.h,v 1.18 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_RCBCOMM_H
#define SM_RCBCOMM_H 1

/*
**  Generic RCB communication context;
**  This module uses
**  - one read RCB: only one message at a time is received and decoded.
**  - one write RCBE: this acts as a fallback RCB entry if allocation fails.
**  - one list of RCBEs to write: a module creates an RCB entry, fills in
**	the necessary data and then calls sm_rcbcom_endrep() to append that
**	RCB entry to the write list (rcbcom_wrrcbl).
**  - event thread task that performs the communication
**
**  The function sm_rcbcom2mod() is called when the fd for the task is
**  ready to write: it takes the first RCB entry from the write list
**  and sends it to the external module.
*/

#include "sm/generic.h"
#include "sm/evthr.h"
#include "sm/rcb.h"
#include "sm/rcbl.h"
#include "sm/queue.h"
#include "sm/pthread.h"

#ifndef RCBCOM_CHECK
# define RCBCOM_CHECK	0
#endif

#ifndef RCBCOMM_DEBUG
# define RCBCOMM_DEBUG	0
#endif

#if RCBCOMM_DEBUG
uint rcbcomm_debug;
# define RCBCOMM_DEBFP	smioerr
# define RCBCOMM_LEV_DPRINTF(lev, x)	do			\
		{						\
			if ((lev) < rcbcomm_debug)		\
				sm_io_fprintf x;		\
		} while (0)
# define RCBCOMM_DPRINTF(x)	sm_io_fprintf x
#else /* RCBCOMM_DEBUG */
# define RCBCOMM_DPRINTF(x)
# define RCBCOMM_LEV_DPRINTF(lev, x)
#endif /* RCBCOMM_DEBUG */

typedef struct rcbcom_ctx_S	rcbcom_ctx_T, *rcbcom_ctx_P;

/* Generic communication context RCBCOMM - external module */
struct rcbcom_ctx_S
{
#if RCBCOM_CHECK
	sm_magic_T	 sm_magic;
#endif
	/* XXX add some magic? */
	sm_evthr_task_P	 rcbcom_tsk;	/* pointer to evthr task */
	sm_rcb_P	 rcbcom_rdrcb;	/* RCB for communication (rd) */
	sm_rcbe_P	 rcbcom_wrrcbe;	/* RCB entry for writing */
	sm_rcbh_T	 rcbcom_wrrcbl;	/* RCB list (wr) */
	pthread_mutex_t	 rcbcom_wrmutex;
};

sm_ret_T sm_rcbe_new_enc(sm_rcbe_P *_prcbe, int _minsz, uint _maxlen);
sm_ret_T sm_rcbcom_open(rcbcom_ctx_P _rcbcom_ctx);
sm_ret_T sm_rcbcom_close(rcbcom_ctx_P _rcbcom_ctx);
sm_ret_T sm_rcbcom_prerep(rcbcom_ctx_P _rcbcom_ctx, sm_evthr_task_P _tsk, sm_rcbe_P *_prcbe);
sm_ret_T sm_rcbcom_endrep(rcbcom_ctx_P _rcbcom_ctx, sm_evthr_task_P _tsk, bool _notified, sm_rcbe_P *_prcbe);
sm_ret_T sm_rcbcom2mod(sm_evthr_task_P _tsk, rcbcom_ctx_P _rcbcom_ctx);

#endif /* SM_RCBCOMM_H */
