/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: dadbstr.h,v 1.17 2005/08/30 17:55:21 ca Exp $
 */

#ifndef SM_DADBSTR_H
#define SM_DADBSTR_H 1

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/types.h"
#include "sm/pthread.h"
#include "sm/net.h"
#include "sm/ring.h"

#ifndef DADB_CHECK
# define DADB_CHECK	1
#endif

typedef struct dadb_ctx_S	dadb_ctx_T, *dadb_ctx_P;
typedef struct dadb_entry_S	dadb_entry_T, *dadb_entry_P;

/*
**  Delivery Agent (SMTPC) DataBase Context
**  For each SMTP client process one dadb_ctx is created which keeps track
**  of that client.  It keeps track of all possible threads in that process
**  by creating an array of dadb_entries.  The size of that array is the
**  maximum number of threads in the DA.  The number of active entries can
**  be dynamically limited to control the load the DA generates.
**  Each dadb_entry describes a session in the DA.
*/

struct dadb_ctx_S
{
#if DADB_CHECK
	sm_magic_T	 sm_magic;
#endif
	pthread_mutex_t	 dadb_mutex;	/* only one mutex for now */
	uint		 dadb_entries_max;	/* maximum number of entries */
	uint		 dadb_entries_lim;	/* current max (dynamic) */
	uint		 dadb_entries_cur;	/* current number of entries */

	/* XXX keep number of "idle" sessions? */

	dadb_entry_P	*dadb_entries;	/* array of entries for DA status */
	/* this array is from 0 to dadb_entries_max-1 */
};

struct dadb_entry_S
{
#if DADB_CHECK
	sm_magic_T	 sm_magic;
#endif
/*
	pthread_mutex_t	 dadbe_mutex;
*/
	uint		 dadbe_flags;

	/*
	**  DA session id: primary key in bht(? not yet!)
	**  only used to tell DA the session id
	*/

	sessta_id_T	 dadbe_da_se_id;

	/* DA transaction id: secondary key in bht */
	sessta_id_T	 dadbe_da_ta_id;
	sessta_id_P	 dadbe_ss_ta_id;	/* pointer to TA id of SMTPS */

	/* this doesn't belong here... -> OCC (open connection cache) */
	ipv4_T		 dadbe_srv_ipv4;		/* XXX HACK! */

#if 0
	/*
	**  Pointer to one recipient for the transaction.
	**  Outgoing from this rcpt all others can be found via aqr_da_link
	**  in the aq_rcpt structure.
	**  XXX if we use this then we don't need to search for the recipients
	**  when a TA result comes in.
	*/

	aq_rcpt_P	 dadbe_rcpt;
#endif /* 0 */

#if DADB_STATS
	/* statistics; used to implement limits */
	uint		 dadbe_ntas;	/* number of transactions */
	uint		 dadbe_nrcpts;	/* number of recipients */
	time_T		 dadbe_opened;	/* session opened */
	time_T		 dadbe_lastuse;	/* DA last used */
#endif /* DA_DB_STATS */
};

#if DADB_CHECK
# define SM_IS_DADB(dadb)	SM_REQUIRE_ISA((dadb), SM_DADB_MAGIC)
# define SM_IS_DADBE(dadbe)	SM_REQUIRE_ISA((dadbe), SM_DADBE_MAGIC)
#else
# define SM_IS_DADB(dadb)	SM_REQUIRE((dadb) != NULL)
# define SM_IS_DADBE(dadbe)	SM_REQUIRE((dadbe) != NULL)
#endif

#endif /* SM_DADBSTR_H */
