/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: batvcnfdef.h,v 1.4 2005/06/09 23:34:38 ca Exp $
 */

#ifndef SM_BATVCNFDEF_H
#define SM_BATVCNFDEF_H 1

#include "sm/generic.h"
#include "sm/batvcnf.h"


#if SM_BATVCNFDEF
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN
sm_conf_definition_T const
batv_flag_names[]
#if SM_BATVCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "Reject_Untagged_Addresses",
	sm_conf_type_choice_value,
	BATV_REJ_UNTAGGED,
	0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "Always_Use_BATV",		sm_conf_type_choice_value,
	BATV_ALWAYSUSE,
	0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "Use_BATV_if_Marked",	sm_conf_type_choice_value,
	BATV_USE_IF_MARKED,
	0, NULL, 0, NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_BATVCNFDEF */
;


EXTERN
sm_conf_definition_T const
batv_key_constraints[]
#if SM_BATVCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "", sm_conf_type_u32_minimum, 0,
	0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "", sm_conf_type_u32_maximum, 9,
	0, NULL, 0, NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_BATVCNFDEF */
;


EXTERN
sm_conf_definition_T
batv_key_defs[]
#if SM_BATVCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "number",		sm_conf_type_u32,
	offsetof(batv_key_T, batv_key_number),	sizeof(uint32_t),
	NULL, SM_CONF_FLAG_STRICTLY_REQUIRED,
	batv_key_constraints, NULL, NULL, "BATV key number" },

{ SM_CONF_DEF_MAGIC, "private",		sm_conf_type_string,
	offsetof(batv_key_T, batv_priv_key),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, "BATV private key" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_BATVCNFDEF */
;


EXTERN
sm_conf_definition_T
batv_key_definitions[]
#if SM_BATVCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "",		sm_conf_type_section,
	offsetof(batv_cnf_T, batvcnf_keys), sizeof(batv_key_T),
	NULL, 0,
	batv_key_defs,
	NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "n", sm_conf_type_array_n,
	offsetof(batv_cnf_T, batvcnf_n), sizeof(uint),
	NULL, 0, NULL, NULL, NULL,
	"number of BATV Keys (implicit)" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_BATVCNFDEF */
;

EXTERN
sm_conf_definition_T
batv_defs[]
#if SM_BATVCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "key", sm_conf_type_array,
		0,	/* offset */
		BATV_MAX_KEYS,	/* size (# of elements) */
		NULL,	/* default */
		SM_CONF_FLAG_MULTIPLE|SM_CONF_FLAG_FLAT,
		batv_key_definitions,
		NULL,  NULL,
		"BATV Key Definitions"
	},

{ SM_CONF_DEF_MAGIC, "delimiter",		sm_conf_type_char,
	offsetof(batv_cnf_T, batvcnf_delim),	sizeof(uchar),
	"/",	0,	NULL,	NULL,	NULL,
	"delimiter for BATV extension in local part" },

{ SM_CONF_DEF_MAGIC, "expiration",		sm_conf_type_u32,
	offsetof(batv_cnf_T, batvcnf_timeout),	sizeof(uint),
	"7",	0,	NULL,	NULL,	NULL,
	"Expiration time for BATV (in days)" },

{ SM_CONF_DEF_MAGIC, "Flags",		sm_conf_type_choice,
	offsetof(batv_cnf_T, batvcnf_flags),	sizeof(uint),
	NULL,	SM_CONF_FLAG_MULTIPLE,		batv_flag_names,
	NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_BATVCNFDEF */
;


#undef EXTERN

#endif /* SM_BATVCNFDEF_H */
