/*
 * Copyright (c) 2000-2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: assert.h,v 1.9 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_ASSERT_H
#define SM_ASSERT_H 1

#include "sm/generic.h"

#if HAVE_ASSERT_H
# include <assert.h>
#else
# define SM_CHECK_ALL		0
#endif

SM_DEAD(void
sm_abort_at(const char *, int, const char *));

SM_DEAD(void PRINTFLIKE(1, 2)
sm_abort(char *, ...));


/*
**  assertion checking
*/

#ifndef SM_CHECK_ALL
# define SM_CHECK_ALL		1
#endif

#ifndef SM_CHECK_REQUIRE
# define SM_CHECK_REQUIRE	SM_CHECK_ALL
#endif

#ifndef SM_CHECK_ENSURE
# define SM_CHECK_ENSURE	SM_CHECK_ALL
#endif

#ifndef SM_CHECK_ASSERT
# define SM_CHECK_ASSERT	SM_CHECK_ALL
#endif

#if SM_CHECK_REQUIRE
# define SM_REQUIRE(cond)	assert(cond)
#else
# define SM_REQUIRE(cond)	((void) 0)
#endif

#define SM_REQUIRE_ISA(obj, magic) \
		SM_REQUIRE((obj) != NULL && (obj)->sm_magic == (magic))

#if SM_CHECK_ENSURE
# define SM_ENSURE(cond)	assert(cond)
#else
# define SM_ENSURE(cond)	((void) 0)
#endif

#if SM_CHECK_ASSERT
# define SM_ASSERT(cond)	assert(cond)
#else
# define SM_ASSERT(cond)	((void) 0)
#endif

/* always panic... */
#define SM_PANIC(txt)	sm_abort txt

#define SM_INSIST(cond) SM_ASSERT(cond)

#endif /* ! SM_ASSERT_H */
