#!/bin/sh
# $Id: t-bounce-0.sh,v 1.24 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test bounces; including text of bounces delivered via lmtp to smtps3
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-bounce-0.ok"
OUT="t-bounce-0.out"
AWKSCRIPT="t-bounce-0.awk"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
alias1: user+alias1
aliase3: <553@local.dom>
553: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

#${CAT} > ${AWKSCRIPT} <<EOF
#EOF

# run some test programs

# ----------------------------------------
# permanent failure from SMTP sink; create a bounce; check content
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -R552@local.host -i 10 -E 1 -X 0 -A 1 -s 10
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<552@local.host>
Remote-MTA: 127.0.0.1
Reason:
552 whatever
during RCPT


Your original mail follows:
EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# temporary failure from SMTP sink; create a bounce; check content
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -R451@local.host -Q '-T 10' -i 20 -s 60 -E 2 -X 0 -A 1
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<451@local.host>
Remote-MTA: 127.0.0.1
Reason:
451 whatever
during RCPT
maximum time in queue exceeded


Your original mail follows:
EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
      ERR=true
    fi

  else
     ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# alias; permanent failure from SMTP sink; create a bounce; check content
TEST=3
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -Raliase3@local.dom -i 10 -E 0 -X 0 -A 1 -s 10
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<553@local.dom>
Expanded from:
<aliase3@local.dom>
Remote-MTA: ${SM_LMTPIPV4D}
Reason:
553 whatever
during RCPT


Your original mail follows:
EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi


# ----------------------------------------
# 2 recipients: alias (fail) and ok;
# permanent failure from SMTP sink; create a bounce; check content
TEST=4
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -R"user@local.host -Raliase3@local.dom" -i 10 -E 1 -X 1 -A 1 -s 10
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<553@local.dom>
Expanded from:
<aliase3@local.dom>
Remote-MTA: ${SM_LMTPIPV4D}
Reason:
553 whatever
during RCPT


Your original mail follows:
EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
      ERR=true
    fi

  else
     ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi

# ----------------------------------------
# 2 failed recipients;
# permanent failure from SMTP sink; create a bounce; check content
# note: the order of entries (Recpient:) is non-deterministic...
TEST=5
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -R"554@local.host -Raliase3@local.dom" -i 10 -E 1 -X 1 -A 1 -s 10
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<554@local.host>
Remote-MTA: 127.0.0.1
Reason:
554 whatever
during RCPT

Recipient:
<553@local.dom>
Expanded from:
<aliase3@local.dom>
Remote-MTA: ${SM_LMTPIPV4D}
Reason:
553 whatever
during RCPT


Your original mail follows:
EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
     # try reverse order
     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<553@local.dom>
Expanded from:
<aliase3@local.dom>
Remote-MTA: ${SM_LMTPIPV4D}
Reason:
553 whatever
during RCPT

Recipient:
<554@local.host>
Remote-MTA: 127.0.0.1
Reason:
554 whatever
during RCPT


Your original mail follows:
EOF
      if ${DIFF} -w ${OK} ${OUT} >/dev/null
      then
        :
      else
        ERR=true
      fi
    fi

  else
     ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
