#!/bin/sh
# $Id: t-t2821-1.sh,v 1.9 2005/05/31 21:00:28 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
test -s stop && exit 1
#
IN=t2821_parse.in
OUT=t2821_parse.out
ERR=t2821_parse.err
ERRORS=0

./t-t2821-1 -l $@ > ${OUT} 2> ${ERR} <<EOF
<sm9@sendmail.org>
<sm9.x@sendmail.org>
<@example.com:sm9@sendmail.org>
<@example.com,@endmail.org:sm9@sendmail.org>
EOF

cat > ${IN} <<EOF
>>><sm9@sendmail.org><<<
OK	>>><sm9@sendmail.org><<<
<sm9@sendmail.org>
domain=sendmail.org
local=sm9
>>><sm9.x@sendmail.org><<<
OK	>>><sm9.x@sendmail.org><<<
<sm9.x@sendmail.org>
domain=sendmail.org
local=sm9.x
>>><@example.com:sm9@sendmail.org><<<
OK	>>><@example.com:sm9@sendmail.org><<<
<sm9@sendmail.org>
domain=sendmail.org
local=sm9
>>><@example.com,@endmail.org:sm9@sendmail.org><<<
OK	>>><@example.com,@endmail.org:sm9@sendmail.org><<<
<sm9@sendmail.org>
domain=sendmail.org
local=sm9
EOF
diff ${OUT} ${IN}
if test $? -ne 0
then
  ERRORS=`expr ${ERRORS} + 1 `
fi

./t-t2821-1 -l -D $@ > ${OUT} 2> ${ERR} <<EOF
<sm9-x+y@sendmail.org>
<sm9+x+y@sendmail.org>
<sm9+x-y@sendmail.org>
<"sm9-x+y"@sendmail.org>
<"sm9+x+y"@sendmail.org>
<"sm9+x-y"@sendmail.org>
<"sm9\-x+y"@sendmail.org>
<"sm9\+x+y"@sendmail.org>
<"sm9\+x-y"@sendmail.org>
EOF

cat > ${IN} <<EOF
>>><sm9-x+y@sendmail.org><<<
OK	>>><sm9-x+y@sendmail.org><<<
<sm9-x+y@sendmail.org>
local=sm9-x+y
>>><sm9+x+y@sendmail.org><<<
OK	>>><sm9+x+y@sendmail.org><<<
<sm9+x+y@sendmail.org>
local=sm9+x+y
>>><sm9+x-y@sendmail.org><<<
OK	>>><sm9+x-y@sendmail.org><<<
<sm9+x-y@sendmail.org>
local=sm9+x-y
>>><"sm9-x+y"@sendmail.org><<<
OK	>>><"sm9-x+y"@sendmail.org><<<
<sm9-x+y@sendmail.org>
local=sm9-x+y
>>><"sm9+x+y"@sendmail.org><<<
OK	>>><"sm9+x+y"@sendmail.org><<<
<sm9+x+y@sendmail.org>
local=sm9+x+y
>>><"sm9+x-y"@sendmail.org><<<
OK	>>><"sm9+x-y"@sendmail.org><<<
<sm9+x-y@sendmail.org>
local=sm9+x-y
>>><"sm9\-x+y"@sendmail.org><<<
OK	>>><"sm9\-x+y"@sendmail.org><<<
<sm9-x+y@sendmail.org>
local=sm9-x+y
>>><"sm9\+x+y"@sendmail.org><<<
OK	>>><"sm9\+x+y"@sendmail.org><<<
<sm9+x+y@sendmail.org>
local=sm9+x+y
>>><"sm9\+x-y"@sendmail.org><<<
OK	>>><"sm9\+x-y"@sendmail.org><<<
<sm9+x-y@sendmail.org>
local=sm9+x-y
EOF
diff ${OUT} ${IN}
if test $? -ne 0
then
  ERRORS=`expr ${ERRORS} + 1 `
fi

# ./t-t2821-1 -l -D $@ > ${OUT} 2> ${ERR} <<EOF
# <sm9-x+y@sendmail.org>
# <sm9+x+y@sendmail.org>
# <sm9+x-y@sendmail.org>
# EOF
# 
# diff ${OUT} - <<EOF
# >>><sm9-x+y@sendmail.org><<<
# OK	>>><sm9-x+y@sendmail.org><<<
# <sm9-x+y@sendmail.org>
# local=sm9-x+y
# >>><sm9+x+y@sendmail.org><<<
# OK	>>><sm9+x+y@sendmail.org><<<
# <sm9+x+y@sendmail.org>
# local=sm9+x+y
# >>><sm9+x-y@sendmail.org><<<
# OK	>>><sm9+x-y@sendmail.org><<<
# <sm9+x-y@sendmail.org>
# local=sm9+x-y
# EOF
# if test $? -ne 0
# then
#   ERRORS=`expr ${ERRORS} + 1 `
# fi

if test ${ERRORS} -eq 0
then
  rm -f ${IN} ${OUT} ${ERR}
fi

exit ${ERRORS}
