/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-fgetline0.c,v 1.2 2005/05/08 04:52:28 ca Exp $")

#include "sm/error.h"
#include "sm/io.h"
#include "sm/str.h"
#include "sm/test.h"

static int Verbose;

#define STRLSMALL	16
#define STRLMIN		128
#define STRLMAX		256

static sm_ret_T
readline(sm_file_T *fp, sm_file_T *out, bool safe, bool ok)
{
	sm_ret_T ret;
	sm_str_P str;

	SM_ASSERT(fp != NULL);
	SM_ASSERT(out != NULL);
	str = sm_str_new(NULL, STRLSMALL, STRLSMALL);
	SM_TEST(str != NULL);
	if (str == NULL)
		return sm_err_temp(ENOMEM);
	ret = sm_fgetline0(fp, str);
	if (ok)
		SM_TEST(!sm_is_err(ret));
	else
		SM_TEST(sm_is_err(ret));
	if (safe)
		sm_io_fprintf(out, "'%#S'\n", str);
	else
		sm_io_fprintf(out, "%S", str);
	sm_io_flush(out);
	return ret;
}

static sm_ret_T
rdwr(const char *out, const char *in, sm_str_P str_in, sm_str_P str_out, sm_file_T *fpout)
{
	sm_ret_T ret;
	sm_file_T *fp;

#define FN	"tfget0"

	ret = sm_io_open(SmStStdio, FN, SM_IO_WRONLY, &fp, SM_IO_WHAT_END);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		return ret;

	sm_io_fprintf(fp, out);
	ret = sm_io_close(fp);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		return ret;

	ret = sm_io_open(SmStStdio, FN, SM_IO_RDONLY, &fp, SM_IO_WHAT_END);
	SM_TEST(ret == SM_SUCCESS);
	if (ret == SM_SUCCESS)
	{
		sm_str_clr(str_in);
		sm_str_clr(str_out);
		ret = readline(fp, fpout, false, in != NULL);
		if (in == NULL)
			SM_TEST(sm_is_err(ret));
		else
		{
			SM_TEST(!sm_is_err(ret));
			sm_strprintf(str_in, "%s", in);
			SM_TEST(sm_str_eq(str_in, str_out));
		}
		ret = sm_io_close(fp);
		SM_TEST(ret == SM_SUCCESS);
	}

	return ret;
}

static sm_ret_T
test(void)
{
	sm_ret_T ret;
	sm_str_P str_in, str_out;
	sm_file_T fpout;

	str_in = sm_str_new(NULL, STRLMIN, STRLMAX);
	SM_TEST(str_in != NULL);
	if (str_in == NULL)
		return sm_err_temp(ENOMEM);

	str_out = sm_str_new(NULL, STRLMIN, STRLMAX);
	SM_TEST(str_out != NULL);
	if (str_out == NULL)
		return sm_err_temp(ENOMEM);
	ret = sm_str2file(str_out, &fpout);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		return ret;

	ret = rdwr("Line1\r\n", "Line1", str_in, str_out, &fpout);
	SM_TEST(ret == SM_SUCCESS);
	ret = rdwr("Line2\r\r\n", "Line2\r", str_in, str_out, &fpout);
	SM_TEST(!sm_is_err(ret));
	ret = rdwr("Line3\r \r\n", "Line3\r ", str_in, str_out, &fpout);
	SM_TEST(!sm_is_err(ret));
	ret = rdwr("Line4", NULL, str_in, str_out, &fpout);
	SM_TEST(!sm_is_err(ret));
	ret = rdwr("Line5\r", NULL, str_in, str_out, &fpout);
	SM_TEST(!sm_is_err(ret));
	ret = rdwr("Line6\r \n", NULL, str_in, str_out, &fpout);
	SM_TEST(!sm_is_err(ret));
	ret = rdwr("Line7\n\r", NULL, str_in, str_out, &fpout);
	SM_TEST(!sm_is_err(ret));

	ret = rdwr("This line is too long for a short string\r\n", NULL,
			str_in, str_out, &fpout);
	SM_TEST(!sm_is_err(ret));

	return ret;
}

int
main(int argc, char *argv[])
{
	int c, r;
	char *prg;
	sm_file_T *fp;

	opterr = 0;
	Verbose = 0;
	prg = argv[0];
	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			exit(1);
		}
	}
	sm_test_begin(argc, argv, "test fgetline0 0");
	argc -= optind;
	argv += optind;
	if (argc > 0)
	{
		for (r = 0; r < argc; r++)
		{
			sm_ret_T ret;

			ret = sm_io_open(SmStStdio, argv[r], SM_IO_RDONLY,
					&fp, SM_IO_WHAT_END);
			SM_TEST(ret == SM_SUCCESS);
			if (ret == SM_SUCCESS)
			{
				readline(fp, smioout, true, true);
				ret = sm_io_close(fp);
				SM_TEST(ret == SM_SUCCESS);
			}
		}
	}
	else
	{
		test();
	}
	return sm_test_end();
}
