/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: c2q.h,v 1.17 2005/06/16 00:39:09 ca Exp $
 */

#ifndef SMTPS_C2Q_H
#define SMTPS_C2Q_H 1

#include "sm/generic.h"
#include "sm/reccom.h"
#include "statethreads/st.h"
#include "sm/rcbst.h"
#include "smtpc.h"

/* basic size for RCB in c2q_ctx */
#define C2Q_RCB_SIZE	256

/* SMTPC context for communication with QMGR */
typedef struct c2q_ctx_S	c2q_ctx_T, *c2q_ctx_P;

struct c2q_ctx_S
{
	sc_ctx_P	 c2q_sc_ctx;	/* pointer back to SMTPC context */
	int		 c2q_status;	/* status */
	st_netfd_t	 c2q_fd;	/* fd for communication */
	uint		 c2q_sc_id;	/* smtpc id */
	st_mutex_t	 c2q_wr_mutex;	/* mutex for write */
	st_cond_t	 c2q_cond_rd;	/* cond.var for read */
	st_cond_t	 c2q_cond_wr;	/* cond.var for write */
	uint		 c2q_max_ses;	/* max. # of open sessions */
#if 0
	uint		 c2q_cur_ses;	/* current # of open sessions */
#endif
	sm_rcb_P	 c2q_notify_rcb;

	/*
	**  array of session ctx: associates a session id with a session.
	**  this could also be implemented as a lookup table (e.g., hash)
	**  but since there is a fixed upper limit for the number of
	**  active threads (which shouldn't be too large) a simple array
	**  is used here.
	*/

	sc_sess_P	*c2q_sess;
};

#define C2Q_ST_OK	0
#define C2Q_ST_IOERR	1
#define C2Q_ST_CLOSED	(-1)

/* use flags? */
#define C2Q_IS_IOERR(c2q_ctx)	((c2q_ctx)->c2q_status == C2Q_ST_IOERR)
#define C2Q_SET_IOERR(c2q_ctx)	(c2q_ctx)->c2q_status = C2Q_ST_IOERR
#define C2Q_CLR_IOERR(c2q_ctx)	(c2q_ctx)->c2q_status = C2Q_ST_OK


sm_ret_T c2q_init(sc_ctx_P _sc_ctx, c2q_ctx_P _c2q_ctx, uint _sc_idx, uint _max_ses);
sm_ret_T c2q_stop(c2q_ctx_P _c2q_ctx);
#if 0
sm_ret_T sm_w4q2c(sc_t_ctx_P _sc_t_ctx, uint _tmo);
#endif
sm_ret_T sc_c2q(sc_t_ctx_P _sc_t_ctx, uint32_t _whichstatus, sm_ret_T _ret, c2q_ctx_P _c2q_ctx);
sm_ret_T sc_rm_sess_rq(sc_sess_P _sc_sess, c2q_ctx_P _c2q_ctx);
sm_ret_T sc_rcb_send(sm_rcb_P _rcb, c2q_ctx_P _c2q_ctx);

sm_ret_T c2q_close(c2q_ctx_P _c2q_ctx);
sm_ret_T c2q_connect(sc_ctx_P _sc_ctx, c2q_ctx_P _c2q_ctx, uint _sc_id);

#endif /* SMTPS_C2Q_H */
