#!/bin/sh
# $Id: t-rcpts-1.sh,v 1.6 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias expansion for RFC2821 addresses as well as
# whether an address is part of the list.
# Uses t-rcpt-0, "aliases" map, t-mm
# ------------------------------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=rcpts-1.out
RES=rcpts-1.addr
OK=rcpts-1.ok
TPRG=./t-rcpts-0
VERBOSE=true

# create map for smar
rm -f ${ALIMAP}
${MM} <<EOF
user:	local:
list1:	<user1-1@l1-1.dom> <user2-1@l1-1.dom> <list2@local.dom>
list2:	<user1-2@l2-1.dom> <user2-2@l2-2.dom>
EOF
if test $? -ne 0
then
  echo "$0: t-mm failed"
  exit 1
fi

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
b.c	lmtp:
EOF

TEST=1
# ----------------------------------------
# expand list
${VALGRIND} ${TPRG} -VV '<list1@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address:      <list1@b.c> flags: 24200
address: <list2@local.dom> flags: 24200
address: <user1-1@l1-1.dom> flags: 4000
address: <user1-2@l2-1.dom> flags: 4000
address: <user2-1@l1-1.dom> flags: 4000
address: <user2-2@l2-2.dom> flags: 4000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=2
# ----------------------------------------
# expand list
${VALGRIND} ${TPRG} -VV '<list2@b.c>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
grep '^address:' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address:      <list2@b.c> flags: 24200
address: <user1-2@l2-1.dom> flags: 4000
address: <user2-2@l2-2.dom> flags: 4000
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=3
# ----------------------------------------
# check whether address is in list (no)
${VALGRIND} ${TPRG} -e -S '<no@b.c>' '<list1@b.c>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
found=0
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=4
# ----------------------------------------
# check whether address is in list (yes)
${VALGRIND} ${TPRG} -e -S '<user1-1@l1-1.dom>' '<list1@b.c>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
found=1
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi


rm -f ${OUT} ${RES} ${OK}

exit ${ERRS}
