#!/bin/sh
# $Id: t-port-0.sh,v 1.9 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# simple mailertable routing tests including port numbers
# by contacting SMAR
# uses t-smar-1 and startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=port-0.out
IP=port-0.ip
OK=port-0.ok
TPRG=./t-smar-1
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${SOCK} ${PIDS}

# prepare mailertable
${CAT} > ${MT} <<EOF
local.dom	lmtp:
port100.dom	100^[10.1.2.100]
port400.dom	400^[10.1.2.4]
port200.dom	200^esmtp:[10.1.2.200]
port3000.dom	3000^esmtp:[10.1.2.3]
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1

rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<t1@port100.dom>' > ${OUT} 2>&1
egrep '^(IP|port)' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=10.1.2.100 [a010264]
port=100
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<t2@port400.dom>' > ${OUT} 2>&1
egrep '^(IP|port)' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=10.1.2.4 [a010204]
port=400
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<t3@port200.dom>' > ${OUT} 2>&1
egrep '^(IP|port)' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=10.1.2.200 [a0102c8]
port=200
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVVV '<t4@port3000.dom>' > ${OUT} 2>&1
egrep '^(IP|port)' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=10.1.2.3 [a010203]
port=3000
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

rm -f ${OUT} ${IP} ${OK}

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

exit ${ERRS}
