/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qm_to_ss.c,v 1.29 2005/08/22 18:16:20 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/rcb.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "sm/rcbcomm.h"
#include "qmgr.h"
#include "log.h"

/*
**  QM_TO_SS -- QMGR to SMTPS interface
**	Called by qmgr_smtps if socket is writable.
**
**	Parameters:
**		tsk -- evthr task
**
**	Returns:
**		usual sm_error code
**
**	Last code review: 2003-10-17 03:23:14
*/

sm_ret_T
qm_to_ss(sm_evthr_task_P tsk)
{
	sm_ret_T ret;
	qss_ctx_P qss_ctx;

	SM_IS_EVTHR_TSK(tsk);
	qss_ctx = (qss_ctx_P) tsk->evthr_t_actx;
	SM_IS_QSS_CTX(qss_ctx);
	ret = sm_rcbcom2mod(tsk, &(qss_ctx->qss_com));
	if (sm_is_err(ret))
	{
		qmgr_ctx_P qmgr_ctx;

		qmgr_ctx = qss_ctx->qss_qmgr_ctx,
		SM_IS_QMGR_CTX(qmgr_ctx);
		sm_log_write(qmgr_ctx->qmgr_lctx,
			QM_LCAT_SMTPS, QM_LMOD_TO_SMTPS,
			SM_LOG_ERROR, 8,
			"sev=ERROR, func=qm_to_ss, sm_rcbcom2mod=%m", ret);
	}
	return ret;
}
