#!/bin/sh
# $Id: t-install.sh,v 1.9 2005/09/01 21:13:18 ca Exp $
#
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

# -------------------------------------------------------
# Simple script to setup a dummy installation environment
# this can(?) be used to test sm.setup.sh
# run this in ${OBJ}/misc/
# -------------------------------------------------------

# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../misc
fi
HERE=`pwd`
ERRS=0

# sendmail X queue directory
SMXQDIR=${HERE}/smx
export SMXQDIR

# fake it... can't perform chown unless root but we don't want that here
SMXCHOWN=echo
export SMXCHOWN

# go to right directory
cd ..

make install
# alternatively: try only installation script
# ${SHELL} ${HERE}/sm.setup.sh

# check some results

# main directory
if test ! -d ${SMXQDIR}
then
  echo "$0: missing ${SMXQDIR}"
  exit 1
fi
cd ${SMXQDIR} || exit 1

# check queue directories
for i in 0 1 2 3 4 5 6 7 8 9 A B C D E F
do
  if test -d ${i}
  then
    :
  else
    echo "$0: missing queue dir ${i}"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
  fi
done

SMXCONF=smx.conf
if test -s ${SMXCONF}
then
  ${HERE}/smconf ${SMXCONF} || exit 1
else
  echo "$0: missing ${SMXCONF}"
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit 1
fi

test -s mt || exit 1
test -s mcp.sh || exit 1
test -s lognull.sh || exit 1

# check existence of logfiles
for i in smtps smtpc qmgr smar
do
  test -f ${i}.log || exit 2
done

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
