/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_rdmacros.c,v 1.3 2005/06/21 17:46:06 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/rcb.h"
#include "sm/reccom.h"
#include "pmilter.h"
#include "sm/pmfdef.h"
#include "sm/pmfapi.h"

#if SM_USE_PMILTER

/*
**  SM_PMILT_SETMACRO -- Set a macro at a certain "stage"
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**		stage -- stage
**		macro -- macro
**		value -- value (NOT copied)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmilt_setmacro(pmse_ctx_P pmse_ctx, uint stage, uint32_t macro, sm_str_P value)
{
	uint j;
	pmss_ctx_P pmss_ctx;

	SM_IS_PMSE_CTX(pmse_ctx);
	pmss_ctx = pmse_ctx->pmse_pmss_ctx;
	SM_IS_PMSS_CTX(pmss_ctx);
	if (stage >= PM_SMST_MAX)
		return sm_err_perm(EINVAL);
	for (j = 0; j < PM_MAX_MACROS; j++)
	{
		if (pmss_ctx->pmss_mac_names[stage][j] == macro)
		{
			/* shouldn't happen */
			if (pmse_ctx->pmse_mac_values[stage][j] != NULL)
				SM_STR_FREE(pmse_ctx->pmse_mac_values[stage][j]);
			pmse_ctx->pmse_mac_values[stage][j] = value;
			return SM_SUCCESS;
		}
	}
	return sm_err_perm(SM_E_NOTFOUND);
}

/*
**  SM_PMILT_RDMACRO -- Read one macro from RCB
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**		stage -- stage
**		rcb -- rcb
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmilt_rdmacro(pmse_ctx_P pmse_ctx, uint stage, sm_rcb_P rcb)
{
	sm_ret_T ret;
	uint32_t v, l, rt;
	sm_str_P value;

	ret = sm_rcb_getuint32(rcb, &v);
	if (sm_is_err(ret))
		goto error;
	ret = sm_rcb_get2uint32(rcb, &l, &rt);
	if (sm_is_err(ret))
		goto error;
	if (rt != RT_S2M_MACV)
	{
		ret = sm_error_perm(SM_EM_PMILTER, SM_E_PR_ERR);
		goto error;
	}
	value = NULL;
	ret = sm_rcb_getnstr(rcb, &value, l);
	if (sm_is_err(ret))
		goto error;
	ret = sm_pmilt_setmacro(pmse_ctx, stage, v, value);
	if (sm_is_err(ret))
		goto error;
	return ret;

  error:
	return ret;
}

/*
**  SM_PMILT_RDMACROS -- Read macros from RCB
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**		stage -- stage
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmilt_rdmacros(pmse_ctx_P pmse_ctx, uint stage, sm_rcb_P rcb)
{
	sm_ret_T ret;
	uint32_t v, l, rt;
	sm_str_P value;

	ret = SM_SUCCESS;
	while (!SM_RCB_ISEOB(rcb))
	{
		ret = sm_rcb_get2uint32(rcb, &l, &rt);
		if (sm_is_err(ret))
			goto error;
		switch (rt)
		{
		  case RT_S2M_MACM:
			ret = sm_rcb_getuint32(rcb, &v);
			if (sm_is_err(ret))
				goto error;
			ret = sm_rcb_get2uint32(rcb, &l, &rt);
			if (sm_is_err(ret))
				goto error;
			if (rt != RT_S2M_MACV)
			{
				ret = sm_error_perm(SM_EM_PMILTER, SM_E_PR_ERR);
				goto error;
			}
			value = NULL;
			ret = sm_rcb_getnstr(rcb, &value, l);
			if (sm_is_err(ret))
				goto error;
			ret = sm_pmilt_setmacro(pmse_ctx, stage, v, value);
			if (sm_is_err(ret))
				goto error;
			value = NULL;
			break;

		/* other cases? */
		  default:
			/* skip over other data */
			ret = sm_rcb_skip(rcb, l);
			if (sm_is_err(ret))
				goto error;
#if 0
			ret = sm_error_perm(SM_EM_PMILTER, SM_E_PR_ERR);
			goto error;
#endif
			break;
		}
	}
	return ret;

  error:
	return ret;
}

#endif /* SM_USE_PMILTER */
