/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: unixsocklisten.c,v 1.2 2005/08/24 20:55:32 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/fcntl.h"
#include "sm/unixsock.h"

/*
**  UNIX_SERVER_LISTEN -- Create a socket, bind, and listen.
**
**	Parameters:
**		name -- name to bind to.
**		backlog -- Backlog of connections to accept.
**
**	Returns:
**		New socket fd or sm_error
*/

sm_ret_T
unix_server_listen(const char *name, int backlog)
{
	struct sockaddr_un servaddr;

	SM_REQUIRE(name != NULL);

	sm_memset(&servaddr, 0, sizeof(servaddr));
	servaddr.sun_family = AF_UNIX;
	if (strlcpy(servaddr.sun_path, name, sizeof servaddr.sun_path)
	    >= sizeof servaddr.sun_path)
		return INVALID_SOCKET;
#if HAVE_SOCK_UN_SUN_LEN
	servaddr.sun_len = strlen(name);
#endif

	return unix_server_listen_addr(&servaddr, sizeof(servaddr), backlog);
}
