/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-validdomain.c,v 1.2 2005/08/26 21:51:11 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/str.h"
#include "sm/misc.h"
#include "sm/test.h"
#include "sm/io.h"

static int Verbosity = 0;

#define LEN	256

static void
test(char *domain)
{
	bool ok;
	uint i;
	sm_str_P str;
	char *d;
	char *domainok[] = {
		"a", "a.b", "a-b", "1-2", "1-2-3",
		"[1]",
		"ab.c", "abc.d",
		"ab.cd", "abc.de", "abcd.e", "abcd.ef",
		"a.b.c", "a.b.c.d", "a.b.c.d.e",
		"a.bc", "a.bcd", "a.bcde",
		"12.cd", "1bc.de", "1bcd.e", "1bcd.e2",
		NULL };
	char *domainfail[] = { "-", ".", "a.b.", "[]", "[1.]",
		"a-", "a.-b", "a.b-",
		"1-", "1.-2", "1.2-",
		NULL };


	str = sm_str_new(NULL, LEN, LEN + 2 );
	SM_TEST(str != NULL);
	if (str == NULL)
		return;

	sm_str_clr(str);
	if (domain != NULL)
	{
		sm_str_scat(str, domain);
		ok = validdomain(str, 0);
		SM_TEST(ok);
		goto done;
	}

	for (i = 0; (d = domainok[i]) != NULL; i++)
	{
		sm_str_clr(str);
		sm_str_scat(str, d);
		ok = validdomain(str, 0);
		SM_TEST(ok);
		if (!ok)
			sm_io_fprintf(smioerr, "domain=%s\n", d);
	}

	for (i = 0; (d = domainfail[i]) != NULL; i++)
	{
		sm_str_clr(str);
		sm_str_scat(str, d);
		ok = validdomain(str, 0);
		SM_TEST(!ok);
		if (ok)
			sm_io_fprintf(smioerr, "domain=%s\n", d);
	}

  done:
	sm_str_free(str);
	return;
}

int
main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbosity;
			break;
		}
	}
	sm_test_begin(argc, argv, "test validdomain");

	argc -= optind;
	argv += optind;

	if (argc > 0)
	{
		for (c = 0; c < argc; c++)
		{
			test(argv[c]);
		}
	}
	else
		test(NULL);

	return sm_test_end();
}
