/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-id2idc.c,v 1.2 2005/03/02 19:04:46 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/mta.h"
#include "sm/io.h"
#include "sm/test.h"

static int Verbose = 0;

static int
tstid2idc(int smtpsid)
{
	sm_ret_T ret;
	uint j;
	int r;
	sessta_id_T ta_id;
	id_count_T idc, idcr;
	id_count_T idcs[] =
		{
		0, 1, 16, 31, 32, 63, 64, 127, 128, 255, 256
		, 1023, 1024, 4095, 4096
		, 0x07FFFFFF, 0x0FFFFFFF, 0x08000000, 0x08000001
		, 0x17FFFFFF, 0x1FFFFFFF, 0x18000000, 0x18000001
		, 0x27FFFFFF, 0x2FFFFFFF, 0x28000000, 0x28000001
		, 0x37FFFFFF, 0x3FFFFFFF, 0x38000000, 0x38000001
		, 0x57FFFFFF, 0x5FFFFFFF, 0x58000000, 0x58000001
		, 0xA7FFFFFF, 0xAFFFFFFF, 0xA8000000, 0xA8000001
		, 0xE7FFFFFF, 0xEFFFFFFF, 0xE8000000, 0xE8000001
		, 0x7FFFFFFF, 0xFFFFFFFF
		};

	for (j = 0; j < SM_ARRAY_SIZE(idcs); j++)
	{
		idc = idcs[j];
		r = sm_snprintf(ta_id, SMTP_STID_SIZE, SMTPS_STID_FORMAT,
			idc, smtpsid);
		SM_TEST(r != -1);
		ret = sm_id2idc(ta_id, &idcr);
		SM_TEST(sm_is_success(ret));
		SM_TEST(idcr == idc);
	}
	return 0;
}

static int
testid2idc(void)
{
	int smtpsid;

	for (smtpsid = 0; smtpsid <= SMTPS_MAX_SMTPS_ID; smtpsid++)
		tstid2idc(smtpsid);
	return 0;
}

int
main(int argc, char **argv)
{
	int c;

	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			break;
		}
	}
	sm_test_begin(argc, argv, "test id2idc");
	argc -= optind;
	argv += optind;

	(void) testid2idc();

	return sm_test_end();
}
