/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-errno2err.c,v 1.1 2004/11/18 00:57:55 ca Exp $")

#include "sm/error.h"
#include "sm/test.h"

static sm_ret_T
t_errno2err_mod(int mod)
{
	int err, i;
	int terr[] = { EAGAIN, ENOMEM, ENFILE, EMFILE, ETIMEDOUT};
	int perr[] = { EINVAL, EPERM, EBADF };

	for (i = 0; i < SM_ARRAY_SIZE(terr); i++)
	{
		err = terr[i];
		if (mod == 0)
			SM_TEST(errno2err(err, 0) == sm_err_temp(err));
		else
			SM_TEST(errno2err(err, mod) == sm_error_temp(mod, err));
	}

	for (i = 0; i < SM_ARRAY_SIZE(perr); i++)
	{
		err = perr[i];
		if (mod == 0)
			SM_TEST(errno2err(err, 0) == sm_err_perm(err));
		else
			SM_TEST(errno2err(err, mod) == sm_error_perm(mod, err));
	}

	return 0;
}

static sm_ret_T
t_errno2err(void)
{
	t_errno2err_mod(0);
	t_errno2err_mod(1);
	return 0;
}


int
main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "lV")) != -1)
	{
		switch (c)
		{
		}
	}
	sm_test_begin(argc, argv, "test errno2err");
	t_errno2err();
	return sm_test_end();
}
