/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-dirname.c,v 1.1 2005/04/27 18:36:32 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/misc.h"
#include "sm/test.h"
#include "sm/io.h"

static int Verbosity = 0;

#define LEN	64

static void
test(void)
{
	sm_ret_T ret;
	char dir[LEN];

	ret = sm_dirname("a", dir, sizeof(dir));
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(dir[0] == '\0');

	ret = sm_dirname("/", dir, sizeof(dir));
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(dir[0] == '/');
	SM_TEST(dir[1] == '\0');

	ret = sm_dirname("/abc", dir, sizeof(dir));
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(strcmp(dir, "/") == 0);

	ret = sm_dirname("/abc/", dir, sizeof(dir));
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(strcmp(dir, "/") == 0);

	ret = sm_dirname("/abc/d", dir, sizeof(dir));
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(strcmp(dir, "/abc/") == 0);

	ret = sm_dirname("/abc/d///e/", dir, sizeof(dir));
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(strcmp(dir, "/abc/d/") == 0);

	ret = sm_dirname("/abc/d///e/f", dir, sizeof(dir));
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(strcmp(dir, "/abc/d///e/") == 0);

	ret = sm_dirname("/abc/d", dir, 3);
	SM_TEST(ret != SM_SUCCESS);

	ret = sm_dirname("/abc/d", dir, 4);
	SM_TEST(ret != SM_SUCCESS);

	ret = sm_dirname("/abc/d", dir, 5);
	SM_TEST(ret != SM_SUCCESS);

	ret = sm_dirname("/abc/d", dir, 6);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(strcmp(dir, "/abc/") == 0);

	return;
}

int
main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbosity;
			break;
		}
	}
	sm_test_begin(argc, argv, "test sm_dirname");
#if 0
	argc -= optind;
	argv += optind;
#endif /* 0 */
	test();
	return sm_test_end();
}
