/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strwrelem.c,v 1.3 2004/12/29 23:47:34 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/str.h"
#include "sm/str-int.h"

#if SM_STR_CHECK
/*
**  SM_STR_WR_ELEM -- write an element in a str
**
**	Parameters:
**		str -- string to modify
**		i -- index
**		c -- new element
**
**	Returns:
*/

sm_ret_T
sm_str_wr_elem(sm_str_P str, uint i, uchar c)
{
	SM_IS_BUF(str);
	SM_REQUIRE(str->sm_str_len > i);
	str->sm_str_base[i] = c;
	return SM_SUCCESS;
}
#endif /* SM_STR_CHECK */
