/*
 * Copyright (c) 2000-2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strprint.c,v 1.18 2005/06/02 19:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/rpool.h"
#include "sm/varargs.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"

#include "sm/io.h"

/*
**  SM_STR_VPRINTF -- Append a formatted buf onto the end of a buf.
**
**	Parameters:
**		str -- sm_str_P object to append into.
**		format -- printf style format.
**		ap -- args for format.
**
**	Returns:
**		Number of characters printed into str.
*/

uint
sm_str_vprintf(sm_str_P str, const char *format, va_list ap)
{
	uint flen, left;
	va_list vac;

	SM_VA_COPY(vac, ap);
	SM_REQUIRE(str != NULL);
	SM_REQUIRE(format != NULL);

	while (true)
	{
		left = str->sm_str_size - str->sm_str_len;
		flen = sm_vsnprintf(
				(char *) (str->sm_str_base) + str->sm_str_len,
				left, format, ap);
		va_end(ap);
		if (flen >= left)
		{
			SM_VA_COPY(ap, vac);
			if (sm_is_err(sm_str_resize_data(str, str->sm_str_len
							+ flen + 1)))
				return 0;
		}
		else
			break;
	}

	SM_ASSERT(str->sm_str_len + flen < str->sm_str_size);
	str->sm_str_len += flen;
	SM_ASSERT(str->sm_str_base[str->sm_str_len] == '\0');
	return flen;
}

/*
**  SM_STR_PRINTF -- Append a formatted buf onto the end of a buf.
**
**	Parameters:
**		str -- sm_str_P object to append into.
**		format -- printf style format.
**		... -- args for format.
**
**	Returns:
**		Number of characters printed into str.
*/

uint
sm_str_printf(sm_str_P str, const char *format, ...)
{
	va_list ap;
	uint len;

	SM_REQUIRE(str != NULL);
	SM_REQUIRE(format != NULL);

	va_start(ap, format);
	len = sm_str_vprintf(str, format, ap);
	va_end(ap);
	return len;
}

#if 0
///*
//**  sm_str_readline_stream -- Read lines from a FILE * into a sm_str_P.
//**
//**	Read a character at a time from f until '\n' or EOF
//**	is encountered.  This differs from fgets in that it's
//**	cross platform and will return the last line in a file
//**	that doesn't end with a newline.
//**	It will reuse (and blank out) str for each iteration.
//**	Does not return terminating '\n'.
//**	Curtly ignores (and does not return) any '\r' characters.
//**	Returns NULL if there are no more lines to be read (at EOF)
//**
//**	Parameters:
//**		str -- sm_str_P buffer to reuse (cannot be NULL).
//**		f -- Stream to read from.
//**
//**	Returns:
//**		sm_str_P object that was read into.
//**		NULL if EOF encountered.
//*/
//
///*
//**  sm_str_slurp_stream -- Read rest of FILE * into a sm_str_P
//**
//**	Read from FILE *'s current position verbatim.
//**	sm_str_P is NOT blanked before appending starts.
//**
//**	Parameters:
//**		str -- sm_str_P buffer to read into
//**		f -- Stream to read from
//**
//**	Returns:
//**		Total number of bytes read.
//*/
//
//
///*
//**  sm_str_slurpn_stream -- Read rest of FILE * into a sm_str_P, with limit
//**
//**	Read from FILE *'s current position verbatim.
//**	sm_str_P is NOT blanked before appending starts.
//**
//**	Parameters:
//**		str -- sm_str_P buffer to read into
//**		f -- Stream to read from
//**		max -- maximum number of bytes to read
//**
//**	Returns:
//**		Total number of bytes read.
//**
//**	Notes:
//**		max == 0 => unlimited (just calls sm_str_slurp_stream())
//*/
//
//
///*
//**  BUF_SPLIT_QUOTED -- Split up a buf with possible quoted values
//**
//**	Returns a vector of space stripped, quote stripped tokens.
//**	Honors escaped (with \) quotes (" & ') and spaces.
//**
//**	Would turn the buf:
//**		first "second third" something\ with\ \"quotes\"
//**
//**	Into the vector with the following:
//**		first
//**		second third
//**		something with "quotes"
//**
//**	Note that double quotes will be entered into the vector as an
//**	empty buf.
//**
//**	Parameters:
//**		rpool -- rpool to work in
//**		str -- sm_str_P to split
//**
//**	Returns:
//**		vector of tokens, or NULL on error.
//*/
//
//sm_str_P
//sm_str_readline_stream(str, f)
//	sm_str_P str;
//	FILE *f;
//{
//	char c;
//	uint len = 0;
//
//	SM_REQUIRE(str != NULL);
//	SM_REQUIRE(f != NULL);
//
//	sm_str_blank(str);
//
//	/* NT doesn't support _read on sockets */
//	while (fread(&c, 1, 1, f) == 1)
//	{
//		len++;
//		if (c == '\n')
//		{
//			return str;
//		}
//		/* Ignore '\r's */
//		if (c == '\r')
//			continue;
//		sm_str_scat1(str, c);
//	}
//	/* EOF */
//	if (len == 0)
//		return NULL;
//	else
//		return str;
//}
//
//#define READ_BLOCK 1024  /* Pull this from somewhere? */
//
//uint
//sm_str_slurp_stream(str, f)
//	sm_str_P str;
//	FILE *f;
//{
//	char buf[READ_BLOCK];
//	uint len, total = 0;
//
//	SM_REQUIRE(str != NULL);
//	SM_REQUIRE(f != NULL);
//
//	do {
//		len = fread(buf, 1, READ_BLOCK, f);
//		sm_str_scatn(str, buf, len);
//		total += len;
//	} while (len == READ_BLOCK);
//
//	return total;
//}
//
//uint
//sm_str_slurpn_stream(str, f, max)
//	sm_str_P str;
//	FILE *f;
//	uint max;
//{
//	char buf[READ_BLOCK];
//	uint len;
//	uint toread;
//	uint total = 0;
//
//	SM_REQUIRE(str != NULL);
//	SM_REQUIRE(f != NULL);
//
//	if (max == 0)
//		return sm_str_slurp_stream(str, f);
//
//	do {
//		toread = MIN(READ_BLOCK, max);
//		len = fread(buf, 1, toread, f);
//		sm_str_scatn(str, buf, len);
//		total += len;
//		max -= len;
//	} while (len == toread && max > 0);
//
//	return total;
//}
//
///*
//**  CAUTION: This is rather inefficient for repeated use.  Each subbuf
//**  it processes is cloned into new memory, and the new vector is also
//**  allocated from the provided rpool, and hence neither get freed until
//**  the rpool is destroyed.  No memory from previous calls is re-used.
//**
//**  Use with caution.  The MMA contains a prototype for an improved interface
//**  which will work its way here in due course.
//*/
//
//Vector
//sm_str_split_quoted(rpool, str)
//	sm_rpool_P rpool;
//	const char *str;
//{
//	char *work;
//	Vector v;
//	sm_str_P item;
//	bool quoted_char, in_quotes;
//
//	SM_REQUIRE(str != NULL);
//
//	work = rpool_strdup(rpool, str);
//	item = sm_str_new(rpool, 32, 0);
//	v = vector_new(rpool, 10);
//
//	quoted_char = false;
//	in_quotes = FALSE;
//	for ( ; *work != '\0'; work++)
//	{
//		if (quoted_char)
//		{
//			sm_str_scat1(item, *work);
//			quoted_char = FALSE;
//			continue;
//		}
//
//		if (*work == '\\')
//		{
//			quoted_char = TRUE;
//			continue;
//		}
//
//		if ((*work == '"' || *work == '\'') && !in_quotes)
//		{
//			in_quotes = TRUE;
//			continue;
//		}
//
//		if (in_quotes)
//		{
//			if (*work == '"' || *work == '\'')
//			{
//				in_quotes = FALSE;
//				vector_append(v, sm_str_copy_data(rpool,
//								  item));
//				sm_str_blank(item);
//				continue;
//			}
//			else
//			{
//				sm_str_scat1(item, *work);
//				continue;
//			}
//		}
//		else /* !in_quotes */
//		{
//			if (isascii(*work) && isspace(*work))
//			{
//				if (sm_str_len(item) > 0)
//				{
//					vector_append(v,
//						      sm_str_copy_data(rpool,
//									item));
//					sm_str_blank(item);
//					continue;
//				}
//			}
//			else
//			{
//				sm_str_scat1(item, *work);
//				continue;
//			}
//		}
//	}
//
//	if (quoted_char || in_quotes)
//		return NULL;
//
//	if (sm_str_len(item) > 0)
//		vector_append(v, sm_str_copy_data(rpool, item));
//
//	sm_str_free(item);
//
//	return v;
//}
#endif /* 0 */
