/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbputinit.c,v 1.6 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/str-int.h"
#include "sm/rcb.h"
#include "sm/str2rcb.h"

/*
**  SM_RCB_PUTINIT -- Initialize rcb for putting data into it.
**
**	Parameters:
**		rcb -- sm_rcb_P object to clear.
**		n -- required size.
**
**	Returns:
**		usual sm_error code.
*/

sm_ret_T
sm_rcb_putinit(sm_rcb_P rcb, int n)
{
	SM_IS_RCB(rcb);
	SM_REQUIRE(rcb->sm_rcb_base != NULL);

	rcb->sm_rcb_len = 0;
	if (n > 0 && (uint)n > rcb->sm_rcb_size)
	{
		uint u;

		u = (uint)n;
		SM_STR_INCREASE_R(rcb, u);
	}
	rcb->sm_rcb_rw = n;

	/* just for the fun of it... */
	sm_memzero(rcb->sm_rcb_base, rcb->sm_rcb_size);
	return SM_SUCCESS;
}
