/*
 * Copyright (c) 2000-2002, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fput.c,v 1.5 2005/01/27 00:29:17 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/assert.h"
#include "io-int.h"
#include "fvwrite.h"

/*
**  SM_IO_FPUTS -- add a string to the buffer for the file pointer
**
**	Parameters:
**		fp -- the file pointer for the buffer to be written to
**		s -- string to be placed in the buffer
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_io_fputs(sm_file_T *fp, const uchar *s)
{
	sm_uio_T uio;
	sm_iov_T iov;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	iov.iov_base = (void *) s;
	iov.iov_len = uio.uio_resid = strlen((const char *) s);
	uio.uio_iov = &iov;
	uio.uio_iovcnt = 1;
	return sm_fvwrite(fp, &uio);
}
