/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: dbgcat.c,v 1.5 2005/06/13 19:01:10 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/limits.h"
#include "sm/util.h"

/*
**  SM_SET_DBGLC -- set debug level in a category
**	first[-last][.level]
**	level defaults to 1.
**
**	Parameters:
**		ptr -- (pointer to) argument to parse
**		dbg -- array of debug level
**		dbg_size -- size of array
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_set_dbglc(char **ptr, uint dbg[], uint dbg_size)
{
	sm_ret_T ret;
	ulong first, last, level;

	SM_REQUIRE(ptr != NULL);
	SM_REQUIRE(*ptr != NULL);
	SM_REQUIRE(dbg != NULL);
	SM_REQUIRE(dbg_size > 0);

	ret = sm_parse_ct_lvl(ptr, &first, &last, &level);
	if (sm_is_err(ret))
		return ret;

	if (first >= dbg_size || last >= dbg_size || last < first)
		return sm_err_perm(EINVAL);
	SM_ASSERT(first < dbg_size);
	SM_ASSERT(last < dbg_size);

	/* set the flags */
	while (first <= last)
		dbg[first++] = level;
	return SM_SUCCESS;
}

/*
**  SM_SET_DBGCATS -- set debug level in categories
**	this can be a comma separated list of specifications each of which is
**	parsed by sm_set_dbglc()
**
**	Parameters:
**		ptr -- (pointer to) argument to parse
**		dbg -- array of debug level
**		dbg_size -- size of array
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_set_dbgcats(char **ptr, uint dbg[], uint dbg_size)
{
	sm_ret_T ret;

	SM_REQUIRE(ptr != NULL);
	SM_REQUIRE(*ptr != NULL);
	SM_REQUIRE(dbg != NULL);
	SM_REQUIRE(dbg_size > 0);

	do
	{
		ret = sm_set_dbglc(ptr, dbg, dbg_size);
	} while (ret == SM_SUCCESS && **ptr == ',' && *(++*ptr) != '\0');
	if (ret == SM_SUCCESS && **ptr != '\0')
		ret = sm_err_perm(EINVAL);
	return ret;
}
