/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: edbdel.c,v 1.6 2005/03/11 16:58:19 ca Exp $")
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/assert.h"
#include "sm/str.h"
#include "sm/mta.h"
#include "edb-int.h"
#include "sm/edb.h"
#include "sm/pthread.h"

/*
**  We need a way to put multiple deletes into one transaction.
**  In the "worst" case we could do the same as for changing data:
**  create a list of requests and then write all requests in a single
**  transaction.
*/

/*
**  EDB_TA_RM -- remove TA
**
**	Parameters:
**		edb_ctx - EDB context
**		ta_id - SMTPS transaction id (key for DB)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
edb_ta_rm(edb_ctx_P edb_ctx, sessta_id_T ta_id)
{
	sm_ret_T ret;
	int r;
	DBT db_key;
	DB_TXN *db_txn;

	SM_ASSERT(edb_ctx != NULL);
	r = pthread_mutex_lock(&(edb_ctx->edb_mutex));
	SM_LOCK_OK(r);
	if (r != 0)
	{
		/* LOG? */
		return sm_error_perm(SM_EM_EDB, r);
	}

	/* XXX transaction? */
	db_txn = NULL;
	ret = SM_SUCCESS;
	sm_memzero(&db_key, sizeof(db_key));

	db_key.data = ta_id;
	db_key.size = SMTP_STID_SIZE;

	/* XXX this performs one transaction... how to group this? */
	r = edb_ctx->edb_bdb->del(edb_ctx->edb_bdb, db_txn, &db_key,
			DB_AUTO_COMMIT);
	if (r != 0)
		ret = sm_error_perm(SM_EM_EDB, r);

	/* fall through for unlocking */
	r = pthread_mutex_unlock(&(edb_ctx->edb_mutex));
	SM_ASSERT(r == 0);
	if (r != 0 && sm_is_success(ret))
		ret = sm_error_perm(SM_EM_EDB, r);

	/* cleanup? */
	return ret;
}

/*
**  EDB_RCPT_RM -- remove recipient
**
**	Parameters:
**		edb_ctx - EDB context
**		rcpt_id - recipient id (key for DB)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
edb_rcpt_rm(edb_ctx_P edb_ctx, rcpt_id_T rcpt_id)
{
	sm_ret_T ret;
	int r;
	DBT db_key;
	DB_TXN *db_txn;

	SM_ASSERT(edb_ctx != NULL);
	r = pthread_mutex_lock(&(edb_ctx->edb_mutex));
	SM_LOCK_OK(r);
	if (r != 0)
	{
		/* LOG? */
		return sm_error_perm(SM_EM_EDB, r);
	}

	/* XXX transaction? */
	db_txn = NULL;
	ret = SM_SUCCESS;
	sm_memzero(&db_key, sizeof(db_key));

	db_key.data = rcpt_id;
	db_key.size = SMTP_RCPTID_SIZE;

	/* XXX this performs one transaction... how to group this? */
	r = edb_ctx->edb_bdb->del(edb_ctx->edb_bdb, db_txn, &db_key,
			DB_AUTO_COMMIT);
	if (r != 0)
		ret = sm_error_perm(SM_EM_EDB, r);

	/* fall through for unlocking */
	r = pthread_mutex_unlock(&(edb_ctx->edb_mutex));
	SM_ASSERT(r == 0);
	if (r != 0 && sm_is_success(ret))
		ret = sm_error_perm(SM_EM_EDB, r);

	/* cleanup? */
	return ret;
}
