#!/bin/sh
# $Id: t-dns-0.sh,v 1.10 2005/07/18 17:09:42 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# run t-dnstsk-0 and t-dnstsk-1 with various parameters/arguments.
# ----------------------------------------
#
test -s stop && exit 1

# ??? only for sm9.org tests?
#if test X"${SM_NO_DNS_TEST}" != "X"
#then
#  echo "SKIPPED: $0"
#  exit 0
#fi

#
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../
fi
GETNS=${SD}/../misc/getns.sh
if test -x ${GETNS}
then
  . ${GETNS}
else
NS=`grep '^nameserver' /etc/resolv.conf | head -1 | sed -e 's/nameserver[	 ]*\([0-9][0-9\.]*\).*$/\1/'`
if test -z "${NS}"
then
  echo "$0: no nameserver found"
  exit 0
fi
fi

# Hack... need an IP address which does not respond to DNS
NN="127.1.2.3"

# some domains to test
DOMAINS="aol.com esmtp.org"
for i in ${DOMAINS}
do
  # check the output?
  ./t-dnstsk-0 $@ -i ${NS} ${i} || exit 1
done

# use second DNS test program
./t-dnstsk-1 $@ -i ${NS} ${DOMAINS} || exit 1

# trigger timeout?
./t-dnstsk-1 $@ -t 5000 -i ${NN} ${DOMAINS} || exit 1

exit 0
