/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm-conf-type.h,v 1.6 2005/09/26 23:26:41 ca Exp $
 */

#ifndef SM_CONF_TYPE_H
#define SM_CONF_TYPE_H 1

#if SM_LIBCONF_ALONE
#include "sm-conf.h"
#else
#include "sm/sm-conf.h"
#endif

#include "sm-conf-token.h"

/*
**  SM-CONF-TYPE.H -- value types
*/

struct sm_conf_type_S
{
	int (* sctp_node_to_value)(
		sm_conf_T			*_handle,
		sm_conf_definition_T const	*_def,
		sm_conf_node_T			*_node,
		void				*_value);
	int (* sctp_value_check)(
		sm_conf_T			*_handle,
		sm_conf_definition_T const	*_def,
		void const			*_value);
	int (* sctp_value_null)(
		sm_conf_T			*_handle,
		sm_conf_definition_T const	*_def,
		void				*_value);
};

int sm_conf_node_to_value(
	sm_conf_T			*_smc,
	char const			*_expected,
	sm_conf_node_T			*_node,
	char const			**_text_out,
	size_t				*_text_n_out);

int sm_conf_type_section_node_to_value_subdef(
	sm_conf_T			*_smc,
	sm_conf_definition_T const	*_defs,
	unsigned int			_flags,
	sm_conf_node_T			*_section,
	void				*_data);

sm_conf_node_T * sm_conf_section_anonymous_default(
	sm_conf_T			*_handle,
	char const			*_kw,
	size_t				_kw_n,
	sm_conf_node_T const		*_node);

#endif	/* SM_CONF_TYPE_H */
