/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: log-conf.c,v 1.2 2005/04/14 17:19:30 ca Exp $")

#include "sm/string.h"
#include "sm/io.h"
#include "sm/qmgrcomm.h"
#include "sm/sm-conf.h"
#include "sm/sm-conf-prt.h"

#define SM_CONF_LOG_DEF 1
#include "sm/logcnfdef.h"

typedef struct sm_cnf_S		sm_cnf_T, *sm_cnf_P;
struct sm_cnf_S
{
	sm_logspec_T	smc_log;
};

sm_conf_definition_T
smx_defs[] =
{
{ SM_CONF_DEF_MAGIC, "log", sm_conf_type_section,
	offsetof(sm_cnf_T, smc_log),
	0,
	NULL, SM_CONF_FLAG_KEEP_DEFAULT, sm_log_spec_defs},

/* sentinel */
{ SM_CONF_DEF_MAGIC, NULL }
};

static int Verbose = 0;

static int
dump_defs(sm_file_T *fp, const char *name)
{
	int err;
	sm_cnf_T sm_cnf;
	sm_conf_T *smc;
	sm_conf_node_T *node;

	sm_memzero(&sm_cnf, sizeof(sm_cnf));
	if ((smc = sm_conf_new(name)) == NULL)
	{
		return 1;
	}
	if ((err = sm_conf_read_FILE(smc, name, NULL)) != 0)
	{
		char buf[SM_CONF_ERROR_BUFFER_SIZE];
		char const *e = NULL;

		sm_io_fprintf(smioerr, "%s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(smc, e)) != NULL)
			sm_io_fprintf(smioerr, "%s\n", e);

		sm_conf_destroy(smc);
		return 2;
	}
	err = sm_conf_scan(smc, smx_defs, SM_CONF_FLAG_KEEP_DEFAULT, &sm_cnf);
	if (err != 0)
	{
		sm_prt_conferr(name, smc, err);
	}

	node = sm_conf_root(smc);
	sm_conf_dump_root(smc, node, fp);

	sm_io_flush(fp);
	return 0;
}

int
main(int argc, char **argv)
{
	int r;

	while ((r = getopt(argc, argv, "qV")) != -1)
	{
		switch (r)
		{
		  case 'V':
			Verbose++;
			break;
		  default:
/*
			usage(argv[0]);
*/
			return 1;
		}
	}

	argc -= optind;
	argv += optind;

	if (argc > 0)
		r = dump_defs(smioout, argv[0]);
	return r;
}
