/*
 * Copyright (c) 2000-2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: test.h,v 1.12 2005/06/16 00:09:35 ca Exp $
 */

/*
**  Abstractions for writing a test program.
*/

#ifndef SM_TEST_H
#define SM_TEST_H 1

#include "sm/generic.h"

#if defined(__STDC__) || defined(__cplusplus)
# define SM_TEST(cond) sm_test(cond, #cond, __FILE__, __LINE__)
#else /* defined(__STDC__) || defined(__cplusplus) */
# define SM_TEST(cond) sm_test(cond, "cond", __FILE__, __LINE__)
#endif /* defined(__STDC__) || defined(__cplusplus) */

#define SM_TEST_ERR(ret)			\
	do					\
	{					\
		SM_TEST(!sm_is_err(ret));	\
		if (sm_is_err(ret))		\
			goto error;		\
	} while (0)

extern int SmTestIndex;
extern int SmTestNumErrors;
extern bool SmTestVerbose;
extern int SmTestVerbosity;

void	sm_test_begin(int _argc, char **_argv, char *_testname);
bool	sm_test( bool _success, char *_expr, char *_filename, int _lineno);
int	sm_test_end(void);

#endif /* ! SM_TEST_H */
