/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: qmgrcnf.h,v 1.24 2005/07/27 20:29:59 ca Exp $
 */

#ifndef SM_QMGRCNF_H
#define SM_QMGRCNF_H 1

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/qmgrcto.h"
#include "sm/io.h"
#include "sm/sm-conf.h"
#include "sm/logcnfdef.h"
#include "sm/mcpcnfs.h"
#include "sm/edbcnf.h"

/*
**  QMGR Configuration context
**  Note: this file doesn't contain (yet) the default values, which
**  are required for sm_conf_definition_T
*/

typedef struct qmgr_cnf_S	qmgr_cnf_T, *qmgr_cnf_P;
struct qmgr_cnf_S
{
#if 0
	sm_magic_T	 sm_magic;
#endif
	sm_conf_T	*q_cnf_smc;	/* parsed configuration */
	char		*q_cnf_conffile; /* name of configuration file */
	char		*q_cnf_smtpssock;	/* SMTP Server socket */
	char		*q_cnf_smtpcsock;	/* SMTP Client socket */
	char		*q_cnf_smarsock;	/* SMAR socket */
	char		*q_cnf_cdb_base;	/* CDB base directory */
	char		*q_cnf_hostname;
	char		*q_cnf_ctlsock;		/* control socket */
	char		*q_cnf_confmap_fn;	/* conf map file name */
	char		*q_cnf_confmap_path;	/* conf map full path */
	uint		 q_cnf_wait4srv; /* time to wait for a server */
	uint		 q_cnf_wait4clt; /* time to wait for a client */
	uint		 q_cnf_iqdb_csize; /* IQDB cache size */
	uint		 q_cnf_iqdb_htsize; /* IQDB hash table size */
	uint		 q_cnf_occ_size;	/* OCC hash table size */
	uint		 q_cnf_aq_size;		/* AQ size */
	uint		 q_cnf_optas;	/* max number of open TAs in IBDB */
	uint		 q_cnf_ibdb_delay; /* max time between idbd_commit() */
	uint		 q_cnf_ibdb_size;	/* IBDB size (each file) */
	uint		 q_cnf_min_delay;	/* min delay for retries */
	uint		 q_cnf_max_delay;	/* max delay for retries */

	uint		 q_cnf_tmo_return;	/* max. time in queue */
	uint		 q_cnf_tmo_delay;	/* send warning after this */

	uint		 q_cnf_tmo_ar;	/* max. time in AR */
	uint		 q_cnf_tmo_da;	/* max. time in DA */
	uint		 q_cnf_tmo_sched; /* max time waiting to be scheduled */
	uint		 q_cnf_min_df;	/* minimum free disk space (KB) */
	uint		 q_cnf_ok_df;	/* ok free disk space (KB) */

	uint		 q_cnf_min_thr;
	uint		 q_cnf_max_thr;
	uint		 q_cnf_max_fd;

/* SMTPC: */
	/* initial number of concurrent connections to the same address */
	uint		 q_cnf_init_conc_conn;

	/* max. number of concurrent connections to the same address */
	uint		 q_cnf_max_conc_conn;

	/* recipients per transaction */
	uint		 q_cnf_smtp_rcpts_ta;
	uint		 q_cnf_lmtp_rcpts_ta;

/* SMTPS: */
	/* max number of open connections from the same address */
	uint		 q_cnf_max_open_se;

	/* max connection rate from the same address */
	uint		 q_cnf_max_conn_rate;

	/* connection cache size (rate limiting etc) */
	uint		 q_cnf_ss_cc_size;

/* scheduler */
	/* max.time for a DSN to wait to be scheduled  */
	uint		 q_cnf_t_sched_dsn;

	/* max.number of "recipients" in a DSN */
	uint		 q_cnf_dsn_rcpts_max;

	uint32_t	 q_cnf_flags; /* configuration flags, see qmgr-int.h */

	uint		 q_cnf_loglevel;
	sm_logspec_T	 q_cnf_log;
#if QMGR_DEBUG
	uint		 q_cnf_debug;
#endif

#if QMGR_TEST
	uint32_t	 q_cnf_tests;
#endif

	edb_cnf_T	 q_cnf_edb_cnf;

	MCP_STRUCTS(qmgr_cnf_T, q_cnf)
};

void qmgr_prt_cnf(qmgr_cnf_P _qmgr_cnf, sm_file_T *_fp, bool _all);

#endif /* SM_QMGRCNF_H */
