/*
 * Copyright (c) 2002-2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: bhtable.h,v 1.25 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_BHTABLE_H
#define SM_BHTABLE_H 1
#include "sm/generic.h"

/*
**  Hash table implementation
**  Data layout: bht_S use an array (bht_data) of pointer to bht_entry_S.
**	The hash value of a key specifies the index in that array.
**	If there is already an entry with the same hash value ("collision")
**	then the new element is "inserted", i.e., it is prepended.
*/

#define sm_bht_entry_S bht_entry_S
#define sm_bht_entry_T bht_entry_T
#define sm_bht_entry_P bht_entry_P
#define sm_bht_S bht_S
#define sm_bht_T bht_T
#define sm_bht_P bht_P
#define sm_bht_new bht_new
#define sm_bht_add bht_add
#define sm_bht_locate bht_locate
#define sm_bht_find bht_find
#define sm_bht_rm bht_rm
#define sm_bht_rm_all bht_rm_all
#define sm_bht_destroy bht_destroy
#define sm_bht_walk bht_walk
#define sm_bht_stats bht_stats
#define sm_bhfree_F bhfree_F
#define sm_bhwalk_F bhwalk_F
#define sm_bht_create bht_create
#define sm_bht_setopt bht_setopt
#define sm_bht_getopt bht_getopt
#define sm_bht_open bht_open

#include "sm/bht-int.h"

#ifndef BHT_COMPILE
#undef sm_bht_entry_S
#undef sm_bht_entry_T
#undef sm_bht_entry_P
#undef sm_bht_S
#undef sm_bht_T
#undef sm_bht_P
#undef sm_bht_new
#undef sm_bht_add
#undef sm_bht_locate
#undef sm_bht_find
#undef sm_bht_rm
#undef sm_bht_rm_all
#undef sm_bht_destroy
#undef sm_bht_walk
#undef sm_bht_stats
#undef sm_bhfree_F
#undef sm_bhwalk_F
#undef sm_bht_create
#undef sm_bht_setopt
#undef sm_bht_getopt
#undef sm_bht_open
#endif /* ! BHT_COMPILE */

#endif /* SM_BHTABLE_H */
