/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: config.h,v 1.13 2004/05/05 22:55:07 ca Exp $
 */

#ifndef ISC_SM_CONFIG_H
#define ISC_SM_CONFIG_H

#include "sm/generic.h"

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/magic.h"
#include "sm/types.h"
#include "sm/rpool.h"
#include "sm/memops.h"
#include "sm/io.h"
#include "iscsm/thread.h"

#if !HAVE_SNPRINTF
#define snprintf	sm_snprintf
#define vsnprintf	sm_vsnprintf
#endif /* !HAVE_SNPRINTF */

/* hacks to change isc stuff to sm stuff */

/*
 * Use this to remove the const qualifier of a variable to assign it to
 * a non-const variable or pass it as a non-const function argument ...
 * but only when you are sure it won't then be changed!
 * This is necessary to sometimes shut up some compilers
 * (as with gcc -Wcast-qual) when there is just no other good way to avoid the
 * situation.
 */
#define DE_CONST(konst, var) \
	do { \
		union { const void *k; void *v; } _u; \
		_u.k = konst; \
		var = _u.v; \
	} while (0)


/* assert.h */
#define INSIST(cond) SM_ASSERT(cond)
#define REQUIRE(cond) SM_REQUIRE(cond)
#define ENSURE(cond) SM_ENSURE(cond)

/* magic.h */
#define ISC_MAGIC_VALID(s, m)	((s) != NULL && (s)->magic == (m))
#define ISC_MAGIC(a, b, c, d)	((a) << 24 | (b) << 16 | (c) << 8 | (d))

/* error.h */

/* where to start? */
#define SM_ERR_BASE	256

#define ISC_R_SUCCESS		SM_SUCCESS
#define ISC_R_NOMORE		sm_err_perm(SM_ERR_BASE + 1)
#define ISC_R_UNEXPECTED	sm_err_perm(SM_ERR_BASE + 2)
#define ISC_R_NOSPACE		sm_err_perm(SM_ERR_BASE + 3)
#define ISC_R_RANGE		sm_err_perm(SM_ERR_BASE + 4)
#define ISC_R_INVALIDFILE	sm_err_perm(SM_ERR_BASE + 5)
#define ISC_R_NOTFOUND		sm_err_perm(SM_ERR_BASE + 6)

#define ISC_R_NOMEMORY		sm_err_perm(ENOMEM)
#define isc__errno2result(x)	sm_error_value(x)
#define isc__strerror(n, b, s)	sm_snprintf(b, s, "%d", n)

/* types.h */
#define isc_boolean_t	bool
#define isc_uint8_t	uint8_t
#define isc_uint16_t	uint16_t
#define isc_uint32_t	uint32_t
#define isc_uint64_t	uint64_t
#define isc_offset_t	off_t

#define ISC_FALSE	false
#define ISC_TRUE	true
#define ISC_TF(x)	x

/* memory */
#define isc_mem_get(r, s)	sm_rpool_malloc(r, s)
#define isc_mem_put(r, p, s)	sm_rpool_free(r, p)
#define isc_mem_free(r, p)	sm_rpool_free(r, p)
#define isc_mem_create(a, b, r)	(r) = sm_rpool_new(NULL)
#define isc_mem_strdup(r, s)	sm_rpool_strdup(r, s)

/* msg */
/* XXX HACK XXX */
#define isc_msgcat_get(cat, x, y, str)	str

/* misc */
#define LIBISCCFG_EXTERNAL_DATA
#define LIBISC_EXTERNAL_DATA
#define RUNTIME_CHECK(x)	x
#define UNEXPECTED_ERROR(a,b,c,d)	/* just log it? */
/* to shutup compilers about unused args */
#define UNUSED(x)		((void) (x))

/* XXX HACK XXX */
#define isc_commandline_parse	getopt
#define isc_commandline_index	optind
#define isc_commandline_argument	optarg

#if 0
#define ISC_UINT32_MAX	UINT32_MAX
#define ISC_UINT64_MAX	UINT64_MAX
#endif /* 0 */

#define ISC_PLATFORM_QUADFORMAT	"ll"

#endif /* ISC_SM_CONFIG_H */
