#!/bin/sh
#
# $Id: logroll.sh,v 1.3 2005/05/31 21:11:20 ca Exp $
#
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

# example script to rotate logfiles for sm9
# From: Valdis Kletnieks

DIR=/var/sm9
KEEP=7

cd ${DIR} || exit 1

TARGETS=`ls *.log | sed -e 's/.log$//'`

for i in ${TARGETS};
do
	echo $i
	X=${KEEP}
	while ( [ ${X} -gt 0 ] ) ;
	do
		Y=`expr ${X} - 1`;
		mv -f $i.log.${Y} $i.log.${X} > /dev/null 2>&1
		X=${Y}
	done
	cp $i.log $i.log-0 > /dev/null 2>&1

	# mv only works if the file is reopened...
	# # Magic in the next line - season to taste.
	# OWNER=`/bin/ls -l $i.log | awk '{print $3":"$4}'`
	# mv $i.log $i.log-0 > /dev/null 2>&1
	# touch $i.log
	# chown ${OWNER} $i.log
	# Alternatively, do this kill if .pid files are named right
	# kill -USR2 `cat $i.pid`
done

# is mcp.pid in ${DIR}?
kill -USR2 `cat mcp.pid`

exit 0
