#!/bin/sh
# $Id: t-pmilter-12.sh,v 1.2 2005/10/19 18:34:53 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test pmilter reconnect after smtps restart
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
V=0

SCRIPTS=`cd ${SD} && pwd`

if ../smtps/smtps -VVV | ${GREP} SM_USE_PMILTER >/dev/null
then
  :
else
  echo "$0: smtps not compiled with SM_USE_PMILTER (--enable-pmilter); test SKIPPED"
  exit 0
fi

if test X"`uname`" = "XLinux"
then
  echo "$0: SKIPPED on Linux, needs POSIX conformant pthread implementation"
  exit 0
fi

OUT="t-pmilter-11.out"
PMPRG="-p ../libpmilter/t-pmilter-1"
PMOPT=""

if test X"`uname`" != "XOSF1"
then
while getopts O:p:s:V FLAG
do
  case "${FLAG}" in
    O) PMOPT="${PMOPT} ${OPTARG}";;
    p) PMPRG="-p ${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=unix; path="pmilter.sock";} timeout=2;
 flags=accept_but_reconnect;}
}
EOF

# ----------------------------------------
# reject mail command in pmilter, kill smtps, send another mail which must
# be rejected too as the new smtps is connected to pmilter.
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
SENDER=a@b.c
RCPT=x@y.z
rm -f ${PMIDS}
PMOPTS="-r m=550 -d 9"
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -z ${PMPRG} ${PMOPT} -P "${PMOPTS}" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S${SENDER} -R${RCPT}
then
  ERR=false

  if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
  then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      ERR=true
    fi
  else
    ERR=true
  fi

  # XREF: smtps is started last, hence its the last entry in the file
  SMTPSPID=`tail -1 ${PIDS}`
  if test X"${SMTPSPID}" != "X"
  then
    kill ${SMTPSPID}
    CONF="-f smx.conf"
    sleep 1
    ../smtps/smtps ${CONF} -d 5 >> s${V}.log 2>&1 &
    SMTPSPID=$!
    echo ${SMTPSPID} >> ${PIDS}

    sleep 1
    if ${STE}/smtpc2 -E -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} > ${CLTL} 2>&1
    then
      if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
      then
        if ${GREP} "total=0 " ${CLTL} >/dev/null
        then
          :
        else
          ERR=true
        fi
      else
        ERR=true
      fi
    else
      ERR=true
      echo "$0: test ${TEST} failed"
    fi

  else
    echo "$0: cannot find smtps pid"
  fi
else
    ERR=true
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${PMIDS}

if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
${SD}/stopmts.sh
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
