#!/bin/sh
# $Id: t-mts-prot-0.sh,v 1.9 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test protected recipient
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 14; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }

smtps {
Log_Level = 12;
flags = {access};
protected_recipients {allow_by={sender,client_ip}; match_type=generic_lookup; };
daemon_address = localhost:${SRVPORT};
relay_from = "No.host.";
relay_to = "No.host.";
wait_for_server=4;
}
EOF

# create access map (restrictions)
${CAT} > ${ACC} <<EOF
protectedrcpt:list1@b.c	list:<list1@b.c>
protectedrcpt:list2	list:<list2@b.c> cltaddr:127.0.0.1
protectedrcpt:list3	from:<moderator3@local.dom> cltaddr:1.2.3.4 cltaddr:10
protectedrcpt:list4	bogus:entry
protectedrcpt:long	list:<long@b.c>
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
list1:	<user1-1@sm9.org> <user2-1@sm9.org> <list2@local.dom>
list2:	<user1-2@l2-1.dom> <user2-2@l2-2.dom>
list3:	<user1-3@l3-1.dom> <user2-3@l3-2.dom>
long: <user0@some.long.domain> <user1@some.long.domain> <user2@some.long.domain> <user3@some.long.domain> <user4@some.long.domain> <user5@some.long.domain> <user6@some.long.domain> <user7@some.long.domain> <user8@some.long.domain> <user9@some.long.domain> <user10@some.long.domain> <user11@some.long.domain> <user12@some.long.domain> <user13@some.long.domain> <user14@some.long.domain> <user15@some.long.domain> <user16@some.long.domain> <user17@some.long.domain> <user18@some.long.domain> <user19@some.long.domain> <user20@some.long.domain> <user21@some.long.domain> <user22@some.long.domain> <user23@some.long.domain> <user24@some.long.domain> <user25@some.long.domain> <user26@some.long.domain> <user27@some.long.domain> <user28@some.long.domain> <user29@some.long.domain> <user30@some.long.domain> <user31@some.long.domain> <user32@some.long.domain> <user33@some.long.domain> <user34@some.long.domain> <user35@some.long.domain> <user36@some.long.domain> <user37@some.long.domain> <user38@some.long.domain> <user39@some.long.domain>
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

${CAT} > ${MT} <<EOF
local.host	lmtp:
local.dom	lmtp:
b.c	lmtp:
sm9.org	[127.0.0.1]
l2-1.dom	[127.0.0.1]
l2-2.dom	[127.0.0.1]
l3-1.dom	[127.0.0.1]
l3-2.dom	[127.0.0.1]
some.long.domain	[127.0.0.1]
EOF

# run some test programs

# ----------------------------------------
# access denied
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Ssender${TEST}@b.c -Rlist1@b.c -E 0 -X 0 -A 0
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# ----------------------------------------
# access allowed
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Suser1-1@sm9.org -Rlist1@b.c -E 4 -X 1 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# ----------------------------------------
# access denied
TEST=3
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Ssender${TEST}@b.c -Rlist3@b.c -E 0 -X 0 -A 0
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# ----------------------------------------
# access allowed (client IP)
TEST=4
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Suser1-1@sm9.org -Rlist2@b.c -E 2 -X 1 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# ----------------------------------------
# access allowed
TEST=5
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Suser39@some.long.domain -Rlong@b.c -E 40 -X 1 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# ----------------------------------------
# access denied
TEST=6
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Suser99@some.long.domain -Rlong@b.c -E 0 -X 0 -A 0
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi


# ----------------------------------------
# access allowed
TEST=7
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 14; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 12;
flags = {access};
protected_recipients {allow_by={sender}; };
daemon_address = localhost:${SRVPORT};
relay_from = "No.host.";
relay_to = "No.host.";
wait_for_server=4;
}
EOF
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -SUSER39@some.long.domain -Rlong@b.c -E 40 -X 1 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi


# ----------------------------------------
rm -f ${ACCMAP} ${ALIMAP} ${MTMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
