#!/bin/sh
# $Id: t-mts-ocr-snd-1.sh,v 1.5 2005/05/31 20:55:51 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# send some mails, used by t-mts-ocr-1.sh; see its description!
# ----------------------------------------
#
test -s stop && exit 1
#
# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

TAS=1
THREADS=1
RCPTS=1
TOTAL=1
ERRS=0

SRCPRG=${STE}/smtpc

# ----------------
# first: send some recipients, half of which will tempfail
if ${SRCPRG} ${SRCOPTS} -r ${H}:${SRVPORT} -f's1-ocr-1@dom1.tld' -R'451@dom2.tld' -T 5 -t 10 > ${CLTL} 2>&1
then
  :
else
  ${CAT} ${CLTL}
  ERRS=`expr ${ERRS} + 1 `
fi

sleep 5

# do some checks! how to get smtpc and qmgr pid?
kill -USR1 ${SINKPID}
if test X"${SRVL}" != "X" -a -s "${SRVL}"
then
  ${GREP} 'Transactions * 10' ${SRVL} > /dev/null || { echo "$0: expected 10 attempted transactions"; ERR=true; }
  ${GREP} 'Recipients * 10' ${SRVL} > /dev/null || { echo "$0: expected 10 attempted recipients"; ERR=true; }
  ${GREP} 'Transactions accepted  * 0' ${SRVL} > /dev/null || { echo "$0: expected 0 accepted transactions"; ERR=true; }
  ${GREP} 'Recipients accepted  * 0' ${SRVL} > /dev/null || { echo "$0: expected 0 accepted recipients"; ERR=true; }
fi

sleep 30

# ----------------
# next: send one recipient which will go through
if ${SRCPRG} ${SRCOPTS} -r ${H}:${SRVPORT} -f's2-ocr-1@dom1.tld' -R'r2-ok@dom2.tld'
then
  :
else
  ${CAT} ${CLTL}
  ERRS=`expr ${ERRS} + 1 `
fi

sleep 3

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
