#!/bin/sh
# $Id: t-mts-acc-5.sh,v 1.12 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test access map restrictions: spam friend tests: new version
# uses smtp1.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`
SRCOK="../qmgr/t-mts-acc-2.ok"
EDBROK="t-mts-acc-edbr-2.ok"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

# create restrictions
${CAT} > ${ACC} <<EOF
from:spammer	error:550 5.7.0 spammer
to:abuse@local.dom	QUICK:OK
to:abuse	QUICK:OK
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# run some test programs

# ----------------------------------------
# deny sender
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtp1.sh -Z 'smtpc2' -c '-E' -V '-a' -E 0 -A 0 -X 0 $@ -S"spammer@b.c" -R"someone@local.dom"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
then
  :
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# deny sender, but at RCPT stage (delayed)
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtp1.sh -Z 'smtpc2' -c '-E' -V '-F 7' -E 0 -A 0 -X 0 $@ -S"spammer@b.c" -R"user@local.dom"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'RCPT=error' ${CLTL} >/dev/null
then
  :
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# deny sender, but RCPT is "spam friend"
TEST=3
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<spammer@b.c>
	rcpts_tot=1
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=465
	aqt_rcpts_ar=0
got recipient
	rcpt=<abuse@local.dom>
	aqr_rcpt_idx=0
	aqr_da_idx=1
	aqr_status=465
EOF
if ${SHELL} ${SCRIPTS}/smtp1.sh -O ${EDBROK} -Z 'smtpc2' -c '-E' -V '-F 7' -E 0 -A 1 -X 0 $@ -S"spammer@b.c" -R"abuse@local.dom"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'error' ${CLTL} >/dev/null
then
  ERR=true
else
  :
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
rm -f ${ACCMAP} ${ALIMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
