#!/bin/sh
# $Id: t-bounce-4.sh,v 1.19 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test bounces; including text of bounces delivered via lmtp to smtps3
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-bounce-4.ok"
OUT="t-bounce-4.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# ----------------------------------------
# temporary, then permanent failure from sink; check content
TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<user@x.y>
Remote-MTA: 127.0.0.1
Reason:
551 perm after temp
during final dot


Your original mail follows:
EOF

if ${SHELL} ${SD}/smtp1.sh -s 30 -Y '-2 d' -3 lmtpsock -Ssender@local.dom -R"user@x.y" -i 4 -E 2 -X 2 -A 1
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}
    if ${DIFF} -w ${OK} ${OUT}
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# temporary, then permanent failure from sink; check content
TEST=2
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<user@x.y>
Remote-MTA: 127.0.0.1
Reason:
551 perm after temp
during MAIL


Your original mail follows:
EOF

if ${SHELL} ${SD}/smtp1.sh -s 30 -Y '-2 M' -3 lmtpsock -Ssender@local.dom -R"user@x.y" -i 4 -E 0 -X 2 -A 1
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}
    if ${DIFF} -w ${OK} ${OUT}
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi


# ----------------------------------------
# temporary (RCPT), then permanent (MAIL) error from sink; check content
TEST=3
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<user@x.y>
Remote-MTA: 127.0.0.1
Reason:
551 perm after temp 2
during MAIL


Your original mail follows:
EOF

if ${SHELL} ${SD}/smtp1.sh -s 30 -Y '-3 RM' -3 lmtpsock -Ssender@local.dom -R"user@x.y" -i 4 -E 1 -X 2 -A 1
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}
    if ${DIFF} -w ${OK} ${OUT}
    then
      :
    else
      ERR=true
    fi
  else
     ERR=true
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
