#!/bin/sh
# $Id: mta-running.sh,v 1.6 2005/04/29 22:42:59 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#

PORT=${SRVPORT}
if test $# -ge 1
then
  PORT=$1
fi

MYLOG=mtarunning.log
rm -f ${MYLOG}

# How to check that the MTA is running?
CNT=0
while true
do
  sleep 1
  ${P}/checks/t-net-cl -p ${PORT} -r 6 2>>${MYLOG} && break
  R=$?
  echo "`date`: return=$R" >>${MYLOG}
  CNT=`expr ${CNT} + 1 `
  if test ${CNT} -ge 3
  then
    echo "ERROR: SMTPS on ${PORT} did not start?"
    exit 1
  fi
done
exit 0
