#!/bin/sh
# $Id: t-smar-rvrs-1.sh,v 1.3 2005/10/06 18:24:21 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test access map restrictions (only IP addresses)
# and reverse lookups (PTR).
# Uses smar, t-smar-3, access map, t-mm, startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0 (SM_NO_DNS_TEST is set)"
  exit 0
fi
# this test requires DNS entries for 10.255.255.*
if test X"${SM_HAVE_10_INADDRARPA}" != "Xtrue"
then
  echo "SKIPPED: $0 (SM_HAVE_10_INADDRARPA is not set to true)"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=smar-rvrs-1.out
IP=smar-rvrs-1.ip
OK=smar-rvrs-1.ok
VERBOSE=false
TPRG=./t-smar-3

if test X"`uname`" != "XOSF1"
then
while getopts V FLAG
do
  case "${FLAG}" in
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${ACCMAP} ${SOCK} ${PIDS}

# create access map for tests
${MM} -t'	' -F ${ACCMAP} <<EOF
cltresolve:NO	error:450 4.7.1 get a name
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
# match
${VALGRIND} ${TPRG} 10.255.255.1 > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=rvrs_st, ret=0, stat=1
react=rvrs_name, ret=0, name=one.sm9.org.
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=2
# ----------------------------------------
# does not match
${VALGRIND} ${TPRG} 10.255.255.2 > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='450 4.7.1 get a name
react=rvrs_st, ret=0, stat=2
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=3
# ----------------------------------------
# forward lookup fails
${VALGRIND} ${TPRG} 10.255.255.3 > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=rvrs_st, ret=0, stat=8
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=4
# ----------------------------------------
# reverse lookup fails
${VALGRIND} ${TPRG} 10.255.255.10 > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=rvrs_st, ret=0, stat=4
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
sleep 3

exit ${ERRS}
