/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: log.h,v 1.12 2005/09/15 22:26:46 ca Exp $
 */

#ifndef QMGR_LOG_H
#define QMGR_LOG_H 1

#include "sm/generic.h"
#include "sm/log.h"

#if QMGR_LOG_DEFINES
sm_logcategory_T qmgr_lcats[] =
{
	{ "init", 	0 },
	{ "config", 	0 },
	{ "comm",	0 },
	{ "sched",	0 },
	{ "edb",	0 },
	{ "edbc",	0 },
	{ "smtps",	0 },
	{ "smtpc",	0 },
	{ "da",		0 },
	{ "dastat",	0 },
	{ "cleanup",	0 },
	{ "control",	0 },
	{ NULL, 	0 }
};

sm_logmodule_T qmgr_lmods[] =
{
	{ "comm",	 	0 },
	{ "config",		0 },
	{ "sched",		0 },
	{ "to_smar", 		0 },
	{ "from_smar", 		0 },
	{ "to_smtps", 		0 },
	{ "from_smtps",		0 },
	{ "to_smtpc", 		0 },
	{ "from_smtpc",		0 },
	{ "defedb",		0 },
	{ "edbc",		0 },
	{ "edbs",		0 },
	{ "iqdb",		0 },
	{ "ibdb",		0 },
	{ "bounce",		0 },
	{ "dastat",		0 },
	{ "cleanup",		0 },
	{ "control",		0 },
	{ "query",		0 },
	{ "start",	 	0 },
	{ NULL, 		0 }
};

#else /* QMGR_LOG_DEFINES */

/* should these be global or per qmgr context? */
extern sm_logcategory_T qmgr_lcats[];
extern sm_logmodule_T qmgr_lmods[];

#endif /* QMGR_LOG_DEFINES */

#define QM_LCAT_INIT		(&qmgr_lcats[0])
#define QM_LCAT_COMM		(&qmgr_lcats[1])
#define QM_LCAT_SCHED		(&qmgr_lcats[2])
#define QM_LCAT_EDB		(&qmgr_lcats[3])
#define QM_LCAT_EDBC		(&qmgr_lcats[4])
#define QM_LCAT_SMTPS		(&qmgr_lcats[5])
#define QM_LCAT_SMTPC		(&qmgr_lcats[6])
#define QM_LCAT_DA		(&qmgr_lcats[7])
#define QM_LCAT_DASTAT		(&qmgr_lcats[8])
#define QM_LCAT_CLEANUP		(&qmgr_lcats[9])
#define QM_LCAT_CONTROL		(&qmgr_lcats[10])

/* Backwards compatibility. */
#define QM_LCAT_GENERAL	QMGLOGCATEGORY_GENERAL

#define QM_LMOD_COMM		(&qmgr_lmods[0])
#define QM_LMOD_CONFIG		(&qmgr_lmods[1])
#define QM_LMOD_SCHED		(&qmgr_lmods[2])
#define QM_LMOD_TO_SMAR		(&qmgr_lmods[3])
#define QM_LMOD_FROM_SMAR	(&qmgr_lmods[4])
#define QM_LMOD_TO_SMTPS	(&qmgr_lmods[5])
#define QM_LMOD_FROM_SMTPS	(&qmgr_lmods[6])
#define QM_LMOD_TO_SMTPC	(&qmgr_lmods[7])
#define QM_LMOD_FROM_SMTPC	(&qmgr_lmods[8])
#define QM_LMOD_DEFEDB		(&qmgr_lmods[9])
#define QM_LMOD_EDBC		(&qmgr_lmods[10])
#define QM_LMOD_EDBS		(&qmgr_lmods[11])
#define QM_LMOD_IQDB		(&qmgr_lmods[12])
#define QM_LMOD_IBDB		(&qmgr_lmods[13])
#define QM_LMOD_BOUNCE		(&qmgr_lmods[14])
#define QM_LMOD_DASTAT		(&qmgr_lmods[15])
#define QM_LMOD_CLEANUP		(&qmgr_lmods[16])
#define QM_LMOD_CONTROL		(&qmgr_lmods[17])
#define QM_LMOD_QUERY		(&qmgr_lmods[18])
#define QM_LMOD_START		(&qmgr_lmods[19])

#endif /* QMGR_LOG_H */
