#!/bin/sh
# $Id: t-pass-0.sh,v 1.7 2005/07/21 22:07:40 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test file descriptor passing and restart functionality of mcp
# ----------------------------------------

test -s stop && exit 1

# set for verbose mode to -V...
V=""
ERRS=0
OUT=mcp.out
PIDS=pids
CONF=passfd.conf
# see statethreads/examples/smtps2.c
PID="pid"
L1=smtps2.log
OUT=smtpc2.log
PORT=8000
VERBOSE=false
SOCKET=passfd
SD=`dirname $0`
SEND=../statethreads/examples/smtpc2
. ${SD}/../check2/user.sh
if test $# -ge 1
then
  if test "X"$1 = "X-v"
  then
    VERBOSE=true;
  fi
fi

rm -f ${PIDS} ${PID} ${CONF} ${L1} ${OUT} ${SOCKET}

killit()
{
if test -s ${PIDS}
then
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
  rm -f ${PIDS}
fi

if test -s ${PID}
then
  kill `cat ${PID}`
  rm -f ${PID}
fi
exit 1
}

trap killit 2 15

cat > ${CONF} <<EOF
smtps2 {
	start_action = pass;
	listen_socket { type=inet;port = ${PORT};}
	pass_fd_socket = ${SOCKET};
	min_processes = 1;
	max_processes = 1;
	user = ${USER};
	path = "../statethreads/examples/smtps2";
	arguments = "smtps2 -l . -i -O ${SOCKET} -d 2";
}
EOF

./mcp -t -dddd ${CONF} > ${OUT} 2>&1 &
echo $! >> ${PIDS}

# wait for smtps2 to show up
i=0
while test ! -s ${PID}
do
  sleep 3
  i=`expr ${i} + 1 `
  if test ${i} -ge 4
  then
    echo "$0: ERROR: missing ${PID}"
    ERRS=`expr ${ERRS} + 1 `
    break
  fi
done

rm -f ${OUT}
# send a test message
if ${SEND} -r localhost:${PORT} > ${OUT} 2>&1
then
  if grep total=1 ${OUT} >/dev/null
  then
    :
  else
    echo "$0: ${SEND}: did not send 1 message"
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  echo "$0: ${SEND} failed (1)"
  ERRS=`expr ${ERRS} + 1 `
fi

# kill smtps2
P=`cat ${PID}`
rm -f ${PID}
kill ${P}

# wait for smtps2 to show up again
i=0
while test ! -s ${PID}
do
  sleep 3
  i=`expr ${i} + 1 `
  if test ${i} -ge 4
  then
    echo "$0: ERROR: missing ${PID}"
    ERRS=`expr ${ERRS} + 1 `
    break
  fi
done

rm -f ${OUT}
# send another test message
if ${SEND} -r localhost:${PORT} > ${OUT} 2>&1
then
  if grep total=1 ${OUT} >/dev/null
  then
    :
  else
    echo "$0: ${SEND}: did not send 1 message (2)"
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  echo "$0: ${SEND} failed (2)"
  ERRS=`expr ${ERRS} + 1 `
fi

# stop processes
for i in `cat ${PIDS}`
do
  kill ${i}
done
rm -f ${PIDS}
if test -s ${PID}
then
  kill `cat ${PID}`
  rm -f ${PID}
fi

exit ${ERRS}
