/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: unixsock.c,v 1.12 2005/08/24 20:55:32 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/fcntl.h"
#include "sm/unixsock.h"

/*
**  UNIX_SERVER_LISTEN_ADDR -- Create a socket, bind, and listen.
**
**	Parameters:
**		my_addr -- sockaddr listen on
**		addrlen -- Length of my_addr
**		backlog -- Backlog of connections to accept
**
**	Returns:
**		New socket fd or sm_error
*/

sm_ret_T
unix_server_listen_addr(sockaddr_un_T *my_addr, socklen_T addrlen, int backlog)
{
	int listenfd;
	sm_ret_T ret;

	SM_REQUIRE(my_addr != NULL);
	SM_REQUIRE(backlog > 0);

	/* Open listen port */
	listenfd = socket(AF_UNIX, SOCK_STREAM, 0);
	if (listenfd == -1)
		return sm_error_perm(SM_EM_NET, errno);

	if (bind(listenfd, (sockaddr_T *) my_addr, addrlen) == -1)
	{
		ret = sm_error_perm(SM_EM_NET, errno);
		goto error;
	}

	if (listen(listenfd, backlog) == -1)
	{
		ret = sm_error_perm(SM_EM_NET, errno);
		goto error;
	}
	return listenfd;

 error:
	(void) close(listenfd);
	return ret;
}
